/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.impl.engine.DefaultReactiveExecutor;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.ReactiveExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveExecutorResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/";
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveExecutorResolver.class);
    private FactoryFinder factoryFinder;

    public ReactiveExecutor resolve(CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findFactory("reactive-executor", context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found ReactiveExecutor: {} via: {}{}", new Object[]{type.getName(), this.factoryFinder.getResourcePath(), "reactive-executor"});
            }
            if (ReactiveExecutor.class.isAssignableFrom(type)) {
                ReactiveExecutor answer = (ReactiveExecutor)context.getInjector().newInstance(type, false);
                LOG.debug("Detected and using ReactiveExecutor: {}", (Object)answer);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a ReactiveExecutor implementation. Found: " + type.getName());
        }
        LOG.debug("Creating default ReactiveExecutor");
        return new DefaultReactiveExecutor();
    }

    private Class<?> findFactory(String name, CamelContext context) throws ClassNotFoundException, IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name);
    }
}

