/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Route;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.health.PerformanceCounterEvaluator;
import org.apache.camel.impl.health.RouteHealthCheck;

@DeferredContextBinding
public class RoutesHealthCheckRepository
implements CamelContextAware,
HealthCheckRepository {
    private final ConcurrentMap<Route, HealthCheck> checks = new ConcurrentHashMap<Route, HealthCheck>();
    private Set<String> blacklist;
    private List<PerformanceCounterEvaluator<ManagedRouteMBean>> evaluators;
    private ConcurrentMap<String, Collection<PerformanceCounterEvaluator<ManagedRouteMBean>>> evaluatorMap;
    private volatile CamelContext context;

    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setBlacklistedRoutes(Collection<String> blacklistedRoutes) {
        blacklistedRoutes.forEach(this::addBlacklistedRoute);
    }

    public void addBlacklistedRoute(String routeId) {
        if (this.blacklist == null) {
            this.blacklist = new HashSet<String>();
        }
        this.blacklist.add(routeId);
    }

    public void setEvaluators(Collection<PerformanceCounterEvaluator<ManagedRouteMBean>> evaluators) {
        evaluators.forEach(this::addEvaluator);
    }

    public void addEvaluator(PerformanceCounterEvaluator<ManagedRouteMBean> evaluator) {
        if (this.evaluators == null) {
            this.evaluators = new CopyOnWriteArrayList<PerformanceCounterEvaluator<ManagedRouteMBean>>();
        }
        this.evaluators.add(evaluator);
    }

    public void setRoutesEvaluators(Map<String, Collection<PerformanceCounterEvaluator<ManagedRouteMBean>>> evaluators) {
        evaluators.forEach(this::setRouteEvaluators);
    }

    public void setRouteEvaluators(String routeId, Collection<PerformanceCounterEvaluator<ManagedRouteMBean>> evaluators) {
        evaluators.forEach(evaluator -> this.addRouteEvaluator(routeId, (PerformanceCounterEvaluator<ManagedRouteMBean>)evaluator));
    }

    public void addRouteEvaluator(String routeId, PerformanceCounterEvaluator<ManagedRouteMBean> evaluator) {
        if (this.evaluatorMap == null) {
            this.evaluatorMap = new ConcurrentHashMap<String, Collection<PerformanceCounterEvaluator<ManagedRouteMBean>>>();
        }
        this.evaluatorMap.computeIfAbsent(routeId, id -> new CopyOnWriteArrayList()).add(evaluator);
    }

    public Stream<PerformanceCounterEvaluator<ManagedRouteMBean>> evaluators() {
        return this.evaluators != null ? this.evaluators.stream() : Stream.empty();
    }

    public Stream<PerformanceCounterEvaluator<ManagedRouteMBean>> evaluators(String routeId) {
        return this.evaluatorMap != null ? ((Collection)this.evaluatorMap.getOrDefault(routeId, Collections.emptyList())).stream() : Stream.empty();
    }

    public Stream<HealthCheck> stream() {
        return this.context != null ? this.context.getRoutes().stream().filter(route -> route.getId() != null).filter(route -> this.isNotBlacklisted((Route)route)).map(this::toRouteHealthCheck) : Stream.empty();
    }

    private boolean isNotBlacklisted(Route route) {
        return this.blacklist != null ? !this.blacklist.contains(route.getId()) : true;
    }

    private HealthCheck toRouteHealthCheck(Route route) {
        return this.checks.computeIfAbsent(route, r -> {
            RouteHealthCheck check = new RouteHealthCheck(route, this.evaluatorMap != null ? (Collection)this.evaluatorMap.getOrDefault(r.getId(), this.evaluators) : this.evaluators);
            check.getConfiguration().setEnabled(Boolean.valueOf(true));
            return check;
        });
    }
}

