/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.impl.health.PerformanceCounterEvaluator;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteHealthCheck
extends AbstractHealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteHealthCheck.class);
    private final Route route;
    private final List<PerformanceCounterEvaluator<ManagedRouteMBean>> evaluators;

    public RouteHealthCheck(Route route) {
        this(route, null);
    }

    public RouteHealthCheck(Route route, Collection<PerformanceCounterEvaluator<ManagedRouteMBean>> evaluators) {
        super("camel", "route:" + route.getId());
        this.route = route;
        this.evaluators = ObjectHelper.isNotEmpty(evaluators) ? new ArrayList<PerformanceCounterEvaluator<ManagedRouteMBean>>(evaluators) : Collections.emptyList();
    }

    @Override
    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        if (this.route.getId() != null) {
            ManagedRouteMBean managedRoute;
            ManagedCamelContext managedCamelContext;
            CamelContext context = this.route.getCamelContext();
            ServiceStatus status = context.getRouteController().getRouteStatus(this.route.getId());
            builder.detail("route.id", (Object)this.route.getId());
            builder.detail("route.status", (Object)status.name());
            builder.detail("route.context.name", (Object)context.getName());
            if (this.route.getRouteContext().getRouteController() != null || this.route.getRouteContext().isAutoStartup().booleanValue()) {
                if (status.isStarted()) {
                    builder.up();
                } else if (status.isStopped()) {
                    builder.down();
                    builder.message(String.format("Route %s has status %s", this.route.getId(), status.name()));
                }
            } else {
                LOGGER.debug("Route {} marked as UP (controlled={}, auto-startup={})", new Object[]{this.route.getId(), this.route.getRouteContext().getRouteController() != null, this.route.getRouteContext().isAutoStartup()});
                builder.up();
            }
            if (builder.state() != HealthCheck.State.DOWN && (managedCamelContext = (ManagedCamelContext)context.getExtension(ManagedCamelContext.class)) != null && (managedRoute = managedCamelContext.getManagedRoute(this.route.getId())) != null && !this.evaluators.isEmpty()) {
                for (PerformanceCounterEvaluator<ManagedRouteMBean> evaluator : this.evaluators) {
                    evaluator.test(managedRoute, builder, options);
                    if (builder.state() != HealthCheck.State.DOWN) continue;
                    break;
                }
            }
        }
    }
}

