/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class MethodCallProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware {
    private String id;
    private final Expression expression;

    public MethodCallProcessor(Expression expression) {
        ObjectHelper.notNull((Object)expression, (String)"expression", (Object)((Object)this));
        this.expression = expression;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Object newBody = this.expression.evaluate(exchange, Object.class);
            if (exchange.getException() != null) {
                callback.done(true);
                return true;
            }
            if (newBody != null) {
                boolean copyNeeded;
                Message old = exchange.getMessage();
                boolean bl = copyNeeded = !old.getClass().equals(DefaultMessage.class);
                if (copyNeeded) {
                    DefaultMessage msg = new DefaultMessage(exchange.getContext());
                    msg.copyFromWithNewBody(old, newBody);
                    ExchangeHelper.replaceMessage((Exchange)exchange, (Message)msg, (boolean)true);
                } else {
                    old.setBody(newBody);
                    if (!exchange.hasOut()) {
                        exchange.setOut(exchange.getIn());
                    }
                }
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "MethodCall(" + this.expression + ")";
    }

    public String getTraceLabel() {
        return "methodCall[" + this.expression + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Expression getExpression() {
        return this.expression;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

