/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.component.properties.ClasspathPropertiesSource;
import org.apache.camel.component.properties.FilePropertiesSource;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.component.properties.RefPropertiesSource;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.PropertiesSourceFactory;

public class DefaultPropertiesSourceFactory
implements PropertiesSourceFactory {
    private final PropertiesComponent pc;

    public DefaultPropertiesSourceFactory(PropertiesComponent pc) {
        this.pc = pc;
    }

    public PropertiesSource newFilePropertiesSource(String location) {
        return new FilePropertiesSource(this.pc, new PropertiesLocation("file", location));
    }

    public PropertiesSource newClasspathPropertiesSource(String location) {
        return new ClasspathPropertiesSource(this.pc, new PropertiesLocation("classpath", location));
    }

    public PropertiesSource newRefPropertiesSource(String ref) {
        return new RefPropertiesSource(this.pc, new PropertiesLocation("ref", ref));
    }
}

