/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Map;
import org.apache.camel.PropertiesLookupListener;
import org.apache.camel.spi.PropertiesResolvedValue;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceSupport;

public class DefaultPropertiesLookupListener
extends ServiceSupport
implements PropertiesLookupListener {
    private Map<String, PropertiesResolvedValue> properties;

    public void onLookup(String name, String value, String defaultValue, String source) {
        this.properties.put(name, new PropertiesResolvedValue(name, value, value, defaultValue, source));
    }

    void updateValue(String name, String newValue, String newSource) {
        PropertiesResolvedValue p = this.properties.get(name);
        if (p != null) {
            String source = newSource != null ? newSource : p.source();
            this.properties.put(name, new PropertiesResolvedValue(p.name(), p.originalValue(), newValue, p.defaultValue(), source));
        }
    }

    public PropertiesResolvedValue getProperty(String key) {
        return this.properties.get(key);
    }

    protected void doBuild() throws Exception {
        this.properties = LRUCacheFactory.newLRUCache((int)1000);
    }

    protected void doShutdown() throws Exception {
        this.properties.clear();
    }
}

