/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.base64;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.commons.codec.binary.Base64;

public class Base64DataFormat
implements DataFormat {
    private int lineLength = 76;
    private byte[] lineSeparator = new byte[]{13, 10};
    private boolean urlSafe;

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        byte[] decoded = (byte[])ExchangeHelper.convertToMandatoryType((Exchange)exchange, byte[].class, (Object)graph);
        Base64 codec = this.createCodec();
        byte[] encoded = codec.encode(decoded);
        stream.write(encoded);
    }

    public Object unmarshal(Exchange exchange, InputStream input) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOHelper.copyAndCloseInput((InputStream)input, (OutputStream)baos);
        byte[] encoded = baos.toByteArray();
        baos.close();
        Base64 codec = this.createCodec();
        byte[] decoded = codec.decode(encoded);
        return decoded;
    }

    private Base64 createCodec() {
        return new Base64(this.lineLength, this.lineSeparator, this.urlSafe);
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public byte[] getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(byte[] lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public boolean isUrlSafe() {
        return this.urlSafe;
    }

    public void setUrlSafe(boolean urlSafe) {
        this.urlSafe = urlSafe;
    }
}

