/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator;

import jakarta.validation.Configuration;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.ValidationProviderResolver;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.bootstrap.GenericBootstrap;
import org.apache.camel.CamelContext;
import org.apache.camel.component.bean.validator.ValidationProviderResolverFactory;
import org.apache.camel.support.CamelContextHelper;

public final class ValidatorFactories {
    private ValidatorFactories() {
    }

    public static ValidatorFactory buildValidatorFactory(CamelContext camelContext, boolean ignoreXml, ValidationProviderResolver validationProviderResolver, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, ConstraintValidatorFactory constraintValidatorFactory) {
        ValidationProviderResolverFactory factory;
        if (validationProviderResolver == null && (factory = (ValidationProviderResolverFactory)CamelContextHelper.findSingleByType((CamelContext)camelContext, ValidationProviderResolverFactory.class)) != null) {
            validationProviderResolver = factory.createValidationProviderResolver(camelContext);
        }
        GenericBootstrap bootstrap = Validation.byDefaultProvider();
        if (validationProviderResolver != null) {
            bootstrap.providerResolver(validationProviderResolver);
        }
        Configuration configuration = bootstrap.configure();
        if (messageInterpolator != null) {
            configuration.messageInterpolator(messageInterpolator);
        }
        if (traversableResolver != null) {
            configuration.traversableResolver(traversableResolver);
        }
        if (constraintValidatorFactory != null) {
            configuration.constraintValidatorFactory(constraintValidatorFactory);
        }
        if (ignoreXml) {
            configuration.ignoreXmlConfiguration();
        }
        return configuration.buildValidatorFactory();
    }
}

