/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanTypeHolder;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.util.ObjectHelper;

public class ConstantTypeBeanHolder
implements BeanTypeHolder {
    private final Class<?> type;
    private final BeanInfo beanInfo;

    public ConstantTypeBeanHolder(Class<?> type, CamelContext context) {
        this(type, new BeanInfo(context, type));
    }

    public ConstantTypeBeanHolder(Class<?> type, BeanInfo beanInfo) {
        ObjectHelper.notNull(type, (String)"type");
        ObjectHelper.notNull((Object)beanInfo, (String)"beanInfo");
        this.type = type;
        this.beanInfo = beanInfo;
    }

    public ConstantBeanHolder createCacheHolder() throws Exception {
        Object bean = this.getBean();
        return new ConstantBeanHolder(bean, this.beanInfo);
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public Object getBean() {
        if (this.beanInfo.hasPublicNoArgConstructors()) {
            return this.getBeanInfo().getCamelContext().getInjector().newInstance(this.type, false);
        }
        return null;
    }

    @Override
    public Processor getProcessor() {
        return null;
    }

    @Override
    public boolean supportProcessor() {
        return false;
    }

    @Override
    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public BeanInfo getBeanInfo(Object bean) {
        return null;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }
}

