/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.component.bean.ParameterMappingStrategyHelper;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.PropertyBindingSupport;

public class RegistryBean
implements BeanHolder {
    private final Registry registry;
    private final CamelContext context;
    private final String name;
    private final ParameterMappingStrategy parameterMappingStrategy;
    private final BeanComponent beanComponent;
    private volatile BeanInfo beanInfo;
    private volatile Processor errorHandler;
    private volatile Class<?> clazz;
    private Map<String, Object> options;

    public RegistryBean(CamelContext context, String name, ParameterMappingStrategy parameterMappingStrategy, BeanComponent beanComponent) {
        this.registry = context.getRegistry();
        this.context = context;
        this.parameterMappingStrategy = parameterMappingStrategy != null ? parameterMappingStrategy : ParameterMappingStrategyHelper.createParameterMappingStrategy(context);
        BeanComponent beanComponent2 = this.beanComponent = beanComponent != null ? beanComponent : (BeanComponent)context.getComponent("bean", BeanComponent.class);
        this.name = name != null ? (name.startsWith("ref:") ? name.substring(4) : (name.startsWith("bean:") ? name.substring(5) : name)) : null;
    }

    public String toString() {
        return "bean: " + this.name;
    }

    @Override
    public void setErrorHandler(Processor errorHandler) {
        if (this.beanInfo != null) {
            for (MethodInfo mi : this.beanInfo.getMethods()) {
                mi.setErrorHandler(errorHandler);
            }
        } else {
            this.errorHandler = errorHandler;
        }
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public ConstantBeanHolder createCacheHolder() {
        Object bean = this.getBean(null);
        BeanInfo info = this.createBeanInfo(bean);
        return new ConstantBeanHolder(bean, info);
    }

    @Override
    public Object getBean(Exchange exchange) throws NoSuchBeanException {
        Object bean = this.doGetBean(exchange);
        if (this.options != null && !this.options.isEmpty()) {
            PropertyBindingSupport.build().withRemoveParameters(false).withCamelContext(this.getBeanInfo().getCamelContext()).withProperties(this.options).withTarget(bean).bind();
        }
        return bean;
    }

    private Object doGetBean(Exchange exchange) throws NoSuchBeanException {
        Object value = this.lookupBean();
        if (value != null) {
            if (value instanceof Class) {
                value = this.context.getInjector().newInstance((Class)value);
            }
            return value;
        }
        if (this.clazz == null) {
            this.clazz = this.context.getClassResolver().resolveClass(this.name);
        }
        if (this.clazz == null) {
            throw new NoSuchBeanException(this.name);
        }
        return this.context.getInjector().newInstance(this.clazz);
    }

    @Override
    public Processor getProcessor() {
        return null;
    }

    @Override
    public boolean supportProcessor() {
        return false;
    }

    @Override
    public BeanInfo getBeanInfo() {
        if (this.beanInfo == null) {
            Object bean = this.getBean(null);
            this.beanInfo = this.createBeanInfo(bean);
        }
        return this.beanInfo;
    }

    @Override
    public BeanInfo getBeanInfo(Object bean) {
        return this.createBeanInfo(bean);
    }

    public String getName() {
        return this.name;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public CamelContext getContext() {
        return this.context;
    }

    protected BeanInfo createBeanInfo(Object bean) {
        BeanInfo bi = new BeanInfo(this.context, bean.getClass(), this.parameterMappingStrategy, this.beanComponent);
        if (this.errorHandler != null) {
            for (MethodInfo mi : bi.getMethods()) {
                mi.setErrorHandler(this.errorHandler);
            }
            this.errorHandler = null;
        }
        return bi;
    }

    protected Object lookupBean() {
        return this.registry.lookupByName(this.name);
    }
}

