/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.component.beanstalk.ConnectionSettings;

public class ConnectionSettingsFactory {
    public static final ConnectionSettingsFactory DEFAULT = new ConnectionSettingsFactory();
    private static final Pattern HOST_PORT_TUBE_RE = Pattern.compile("^(([\\w.-]+)(:([\\d]+))?/)?([\\w%+]*)$");

    public ConnectionSettings parseUri(String remaining) throws IllegalArgumentException {
        Matcher m = HOST_PORT_TUBE_RE.matcher(remaining);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("Invalid path format: %s - should be [<hostName>[:<port>]/][<tubes>]", remaining));
        }
        String host = m.group(2) != null ? m.group(2) : "localhost";
        int port = m.group(4) != null ? Integer.parseInt(m.group(4)) : 11300;
        String tubes = m.group(5) != null ? m.group(5) : "";
        return new ConnectionSettings(host, port, tubes);
    }
}

