/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk.processors;

import com.surftools.BeanstalkClient.Client;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.beanstalk.BeanstalkEndpoint;
import org.apache.camel.component.beanstalk.BeanstalkExchangeHelper;
import org.apache.camel.component.beanstalk.processors.DefaultCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseCommand
extends DefaultCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ReleaseCommand.class);

    public ReleaseCommand(BeanstalkEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void act(Client client, Exchange exchange) throws NoSuchHeaderException {
        int delay;
        long priority;
        Message in = exchange.getIn();
        long jobId = BeanstalkExchangeHelper.getJobID(exchange);
        boolean result = client.release(jobId, priority = BeanstalkExchangeHelper.getPriority(this.endpoint, in), delay = BeanstalkExchangeHelper.getDelay(this.endpoint, in));
        if (!result) {
            LOG.warn("Failed to release job {} (priority {}, delay {})", new Object[]{jobId, priority, delay});
        } else {
            LOG.debug("Job {} released with priority {}, delay {} seconds. Result is {}", new Object[]{jobId, priority, delay, result});
        }
        this.answerWith(exchange, "beanstalk.result", result);
    }
}

