/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.csv;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.bindy.BindyAbstractDataFormat;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyCsvFactory;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.WrappedException;
import org.apache.camel.dataformat.bindy.util.ConverterUtils;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="bindy-csv")
public class BindyCsvDataFormat
extends BindyAbstractDataFormat {
    private static final Logger LOG = LoggerFactory.getLogger(BindyCsvDataFormat.class);

    public BindyCsvDataFormat() {
    }

    public BindyCsvDataFormat(Class<?> type) {
        super(type);
    }

    public String getDataFormatName() {
        return "bindy-csv";
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        BindyCsvFactory factory = (BindyCsvFactory)this.getFactory();
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        byte[] bytesCRLF = ConverterUtils.getByteReturn(factory.getCarriageReturn());
        if (factory.getGenerateHeaderColumnNames()) {
            String result = factory.generateHeader();
            Object bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write((byte[])bytes);
            outputStream.write(bytesCRLF);
        }
        ArrayList<Map> models = new ArrayList<Map>();
        if (body instanceof Map) {
            body = Collections.singleton(body).iterator();
        }
        for (Object model : org.apache.camel.support.ObjectHelper.createIterable((Object)body)) {
            if (model instanceof Map) {
                models.add((Map)model);
                continue;
            }
            String name = model.getClass().getName();
            HashMap<String, Object> row = new HashMap<String, Object>(1);
            row.put(name, model);
            row.putAll(this.createLinkedFieldsModel(model));
            models.add(row);
        }
        Iterator modelsMap = models.iterator();
        while (modelsMap.hasNext()) {
            String result = factory.unbind(this.getCamelContext(), (Map)modelsMap.next());
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            if (!factory.isEndWithLineBreak() && !modelsMap.hasNext()) continue;
            outputStream.write(bytesCRLF);
        }
    }

    private boolean checkEmptyStream(BindyCsvFactory factory, InputStream inputStream) throws IOException {
        boolean allowEmptyStream = factory.isAllowEmptyStream();
        boolean isStreamEmpty = false;
        boolean canReturnEmptyListOfModels = false;
        if (inputStream == null || inputStream.available() == 0) {
            isStreamEmpty = true;
        }
        if (isStreamEmpty && allowEmptyStream) {
            canReturnEmptyListOfModels = true;
        }
        return canReturnEmptyListOfModels;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        block23: {
            InputStreamReader in;
            ArrayList<Map<String, Object>> models;
            BindyCsvFactory factory;
            block21: {
                ArrayList<Map<String, Object>> arrayList;
                block22: {
                    factory = (BindyCsvFactory)this.getFactory();
                    ObjectHelper.notNull((Object)factory, (String)"not instantiated");
                    models = new ArrayList<Map<String, Object>>();
                    in = null;
                    if (!this.checkEmptyStream(factory, inputStream)) break block21;
                    arrayList = models;
                    if (in == null) break block22;
                    {
                        catch (Throwable throwable) {
                            if (in != null) {
                                IOHelper.close(in, (String)"in", (Logger)LOG);
                            }
                            throw throwable;
                        }
                    }
                    IOHelper.close(in, (String)"in", (Logger)LOG);
                }
                return arrayList;
            }
            in = new InputStreamReader(inputStream, ExchangeHelper.getCharsetName((Exchange)exchange));
            String separator = factory.getSeparator();
            String quote = factory.getQuote();
            ObjectHelper.notNull((Object)separator, (String)"The separator has not been defined in the annotation @CsvRecord or not instantiated during initModel.");
            Boolean removeQuotes = factory.getRemoveQuotes();
            AtomicInteger count = new AtomicInteger();
            Stream<String> lines = new BufferedReader(in).lines();
            Throwable throwable = null;
            try {
                int linesToSkip = 0;
                if (factory.getSkipFirstLine()) {
                    linesToSkip = 1;
                }
                try {
                    lines.skip(linesToSkip).forEachOrdered(this.consumeFile(factory, models, separator, removeQuotes, quote, count));
                }
                catch (WrappedException e) {
                    throw e.getWrappedException();
                }
                if (models.isEmpty() && !this.isAllowEmptyStream()) {
                    throw new IllegalArgumentException("No records have been defined in the CSV");
                }
                object = this.extractUnmarshalResult(models);
                if (in == null) break block23;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lines != null) {
                        if (throwable != null) {
                            try {
                                lines.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            lines.close();
                        }
                    }
                }
            }
            IOHelper.close((Closeable)in, (String)"in", (Logger)LOG);
        }
        return object;
    }

    private Consumer<String> consumeFile(BindyCsvFactory factory, List<Map<String, Object>> models, String separator, Boolean removeQuotes, String quote, AtomicInteger count) {
        return line -> {
            try {
                String trimmedLine = separator.equals("\t") ? line.replaceAll("[ \\n\\x0B\\f\\r]+$", "") : line.trim();
                count.incrementAndGet();
                Map<String, Object> model = factory.factory();
                Pattern pattern = Pattern.compile(separator);
                Matcher matcher = pattern.matcher(trimmedLine);
                ArrayList<String> separators = new ArrayList<String>();
                while (matcher.find()) {
                    separators.add(matcher.group());
                }
                if (!separators.isEmpty()) {
                    separators.add((String)separators.get(separators.size() - 1));
                }
                String[] tokens = pattern.split(trimmedLine, factory.getAutospanLine() ? factory.getMaxpos() : -1);
                List<String> result = Arrays.asList(tokens);
                if (removeQuotes.booleanValue()) {
                    result = this.unquoteTokens(result, separators, quote);
                }
                if (result.isEmpty()) {
                    throw new IllegalArgumentException("No records have been defined in the CSV");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Size of the record splitted : {}", (Object)result.size());
                }
                factory.bind(this.getCamelContext(), result, model, count.get());
                factory.link(model);
                models.add(model);
                LOG.debug("Graph of objects created: {}", model);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        };
    }

    private List<String> unquoteTokens(List<String> result, List<String> separators, String quote) {
        StringBuilder current = new StringBuilder();
        boolean inProgress = false;
        ArrayList<String> answer = new ArrayList<String>();
        int idxSeparator = 0;
        for (String s : result) {
            boolean canStart = false;
            boolean canClose = false;
            boolean cutStart = false;
            boolean cutEnd = false;
            if (s.startsWith(quote)) {
                if (s.length() == 1) {
                    s = "";
                    if (inProgress) {
                        canClose = true;
                    } else {
                        canStart = true;
                    }
                } else {
                    cutStart = true;
                    canStart = true;
                }
            }
            if (s.endsWith(quote)) {
                cutEnd = true;
                canClose = true;
            }
            if (cutEnd || cutStart) {
                s = s.substring(cutStart ? 1 : 0, cutEnd ? s.length() - 1 : s.length());
            }
            if (inProgress) {
                current.append(separators.get(idxSeparator));
                current.append(s);
                if (canClose) {
                    answer.add(current.toString());
                    current.setLength(0);
                    inProgress = false;
                }
            } else if (canStart && !canClose) {
                current.append(s);
                inProgress = true;
            } else {
                answer.add(s);
            }
            ++idxSeparator;
        }
        if (current.length() > 0) {
            answer.add(current.toString());
            current.setLength(0);
        }
        return answer;
    }

    @Override
    protected BindyAbstractFactory createModelFactory(FormatFactory formatFactory) throws Exception {
        BindyCsvFactory bindyCsvFactory = new BindyCsvFactory(this.getClassType());
        bindyCsvFactory.setFormatFactory(formatFactory);
        return bindyCsvFactory;
    }
}

