/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.AbstractNumberFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class BigDecimalFormatFactory
extends AbstractFormatFactory {
    public BigDecimalFormatFactory() {
        this.supportedClasses.add(BigDecimal.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isEmpty((String)formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new BigDecimalFormat(formattingOptions.isImpliedDecimalSeparator(), formattingOptions.getPrecision(), formattingOptions.getLocale());
    }

    private static class BigDecimalFormat
    extends AbstractNumberFormat<BigDecimal> {
        BigDecimalFormat(boolean impliedDecimalPosition, int precision, Locale locale) {
            super(impliedDecimalPosition, precision, locale);
        }

        @Override
        public String format(BigDecimal object) throws Exception {
            return !super.hasImpliedDecimalPosition() ? super.getFormat().format(object) : super.getFormat().format(object.multiply(new BigDecimal(super.getMultiplier())));
        }

        @Override
        public BigDecimal parse(String string) throws Exception {
            BigDecimal result = new BigDecimal(string.trim());
            if (super.hasImpliedDecimalPosition()) {
                result = result.divide(new BigDecimal(super.getMultiplier()), super.getPrecision(), RoundingMode.HALF_EVEN);
            } else if (super.getPrecision() != -1) {
                result = result.setScale(super.getPrecision());
            }
            return result;
        }
    }
}

