/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.UnicodeHelper;
import org.apache.camel.dataformat.bindy.annotation.BindyConverter;
import org.apache.camel.dataformat.bindy.annotation.DataField;
import org.apache.camel.dataformat.bindy.annotation.FixedLengthRecord;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.format.FormatException;
import org.apache.camel.dataformat.bindy.util.ConverterUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindyFixedLengthFactory
extends BindyAbstractFactory
implements BindyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BindyFixedLengthFactory.class);
    boolean isOneToMany;
    private Map<Integer, DataField> dataFields = new TreeMap<Integer, DataField>();
    private Map<Integer, Field> annotatedFields = new TreeMap<Integer, Field>();
    private int numberOptionalFields;
    private int numberMandatoryFields;
    private int totalFields;
    private boolean hasHeader;
    private boolean skipHeader;
    private boolean isHeader;
    private boolean hasFooter;
    private boolean skipFooter;
    private boolean isFooter;
    private char paddingChar;
    private int recordLength;
    private boolean ignoreTrailingChars;
    private boolean ignoreMissingChars;
    private boolean countGrapheme;
    private Class<?> header = Void.TYPE;
    private Class<?> footer = Void.TYPE;

    public BindyFixedLengthFactory(Class<?> type) throws Exception {
        super(type);
        this.initFixedLengthModel();
    }

    public void initFixedLengthModel() {
        this.initAnnotatedFields();
        this.initFixedLengthRecordParameters();
    }

    @Override
    public void initAnnotatedFields() {
        for (Class cl : this.models) {
            ArrayList<Field> linkFields = new ArrayList<Field>();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Class retrieved: {}", (Object)cl.getName());
            }
            for (Field field : cl.getDeclaredFields()) {
                Link linkField;
                DataField dataField = field.getAnnotation(DataField.class);
                if (dataField != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Position defined in the class: {}, position: {}, Field: {}", new Object[]{cl.getName(), dataField.pos(), dataField});
                    }
                    if (dataField.required()) {
                        ++this.numberMandatoryFields;
                    } else {
                        ++this.numberOptionalFields;
                    }
                    this.dataFields.put(dataField.pos(), dataField);
                    this.annotatedFields.put(dataField.pos(), field);
                }
                if ((linkField = field.getAnnotation(Link.class)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Class linked: {}, Field: {}", (Object)cl.getName(), (Object)field);
                }
                linkFields.add(field);
            }
            if (!linkFields.isEmpty()) {
                this.annotatedLinkFields.put(cl.getName(), linkFields);
            }
            this.totalFields = this.numberMandatoryFields + this.numberOptionalFields;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Number of optional fields: {}", (Object)this.numberOptionalFields);
            LOG.debug("Number of mandatory fields: {}", (Object)this.numberMandatoryFields);
            LOG.debug("Total: {}", (Object)this.totalFields);
        }
    }

    @Override
    public void bind(CamelContext camelContext, List<String> data, Map<String, Object> model, int line) throws Exception {
    }

    public void bind(CamelContext camelContext, String recordStr, Map<String, Object> model, int line) throws Exception {
        int pos = 1;
        int counterMandatoryFields = 0;
        int offset = 1;
        UnicodeHelper record = new UnicodeHelper(recordStr, this.countGrapheme ? UnicodeHelper.Method.GRAPHEME : UnicodeHelper.Method.CODEPOINTS);
        Collection<DataField> c = this.dataFields.values();
        for (DataField dataField : c) {
            String token;
            int length = dataField.length();
            String delimiter = dataField.delimiter();
            if (length == 0 && dataField.lengthPos() != 0) {
                Field lengthField = this.annotatedFields.get(dataField.lengthPos());
                lengthField.setAccessible(true);
                Object modelObj = model.get(lengthField.getDeclaringClass().getName());
                Object lengthObj = lengthField.get(modelObj);
                length = (Integer)lengthObj;
            }
            if (length < 1 && delimiter == null && dataField.lengthPos() == 0) {
                throw new IllegalArgumentException("Either length or delimiter must be specified for the field : " + dataField.toString());
            }
            if (offset - 1 <= -1) {
                throw new IllegalArgumentException("Offset/Position of the field " + dataField.toString() + " cannot be negative");
            }
            if (dataField.pos() > offset) {
                LOG.debug("skipping ahead [{}] chars.", (Object)(dataField.pos() - offset));
                offset = dataField.pos();
            }
            if (length > 0) {
                if (record.length() < offset) {
                    token = "";
                } else {
                    int endIndex = offset + length - 1;
                    if (endIndex > record.length()) {
                        endIndex = record.length();
                    }
                    token = record.substring(offset - 1, endIndex);
                }
                offset += length;
            } else if (!delimiter.equals("")) {
                UnicodeHelper tempToken = new UnicodeHelper(record.substring(offset - 1, record.length()), this.countGrapheme ? UnicodeHelper.Method.GRAPHEME : UnicodeHelper.Method.CODEPOINTS);
                token = tempToken.substring(0, tempToken.indexOf(delimiter));
                offset += token.length() + 1;
            } else {
                token = "";
            }
            if (dataField.trim()) {
                token = this.trim(token, dataField, this.paddingChar);
            }
            if (dataField.required()) {
                ++counterMandatoryFields;
                if (token.equals("")) {
                    throw new IllegalArgumentException("The mandatory field defined at the position " + pos + " is empty for the line: " + line);
                }
            }
            Field field = this.annotatedFields.get(dataField.pos());
            field.setAccessible(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pos/Offset: {}, Data: {}, Field type: {}", new Object[]{offset, token, field.getType()});
            }
            FormattingOptions formattingOptions = ConverterUtils.convert(dataField, field.getType(), field.getAnnotation(BindyConverter.class), this.getLocale());
            Format<?> format = this.formatFactory.getFormat(formattingOptions);
            Object modelField = model.get(field.getDeclaringClass().getName());
            Object value = null;
            if ("".equals(token)) {
                token = dataField.defaultValue();
            }
            if (!"".equals(token)) {
                try {
                    value = format.parse(token);
                }
                catch (FormatException ie) {
                    throw new IllegalArgumentException(ie.getMessage() + ", position: " + offset + ", line: " + line, ie);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Parsing error detected for field defined at the position/offset: " + offset + ", line: " + line, e);
                }
            } else {
                value = BindyFixedLengthFactory.getDefaultValueForPrimitive(field.getType());
            }
            if (value != null && !dataField.method().isEmpty()) {
                String methodName;
                Class clazz = dataField.method().contains(".") ? camelContext.getClassResolver().resolveMandatoryClass(dataField.method().substring(0, dataField.method().lastIndexOf(46))) : field.getType();
                Method m = ReflectionHelper.findMethod((Class)clazz, (String)(methodName = dataField.method().substring(dataField.method().lastIndexOf(46) + 1, dataField.method().length())), (Class[])new Class[]{field.getType()});
                if (m != null) {
                    value = org.apache.camel.support.ObjectHelper.invokeMethod((Method)m, null, (Object[])new Object[]{value});
                } else {
                    m = ReflectionHelper.findMethod((Class)clazz, (String)methodName, (Class[])new Class[0]);
                    value = org.apache.camel.support.ObjectHelper.invokeMethod((Method)m, (Object)value, (Object[])new Object[0]);
                }
            }
            field.set(modelField, value);
            ++pos;
        }
        if (offset <= record.length() && !record.substring(offset - 1, record.length()).trim().equals("") && !this.isIgnoreTrailingChars()) {
            throw new IllegalArgumentException("Unexpected / unmapped characters found at the end of the fixed-length record at line : " + line);
        }
        LOG.debug("Counter mandatory fields: {}", (Object)counterMandatoryFields);
        if (pos < this.totalFields) {
            throw new IllegalArgumentException("Some fields are missing (optional or mandatory), line: " + line);
        }
        if (counterMandatoryFields < this.numberMandatoryFields) {
            throw new IllegalArgumentException("Some mandatory fields are missing, line: " + line);
        }
    }

    private String trim(String token, DataField dataField, char paddingChar) {
        char myPaddingChar = dataField.paddingChar();
        if (dataField.paddingChar() == '\u0000') {
            myPaddingChar = paddingChar;
        }
        if ("R".equals(dataField.align())) {
            return this.leftTrim(token, myPaddingChar);
        }
        if ("L".equals(dataField.align())) {
            return this.rightTrim(token, myPaddingChar);
        }
        token = this.leftTrim(token, myPaddingChar);
        return this.rightTrim(token, myPaddingChar);
    }

    private String rightTrim(String token, char myPaddingChar) {
        StringBuilder sb = new StringBuilder(token);
        while (sb.length() > 0 && myPaddingChar == sb.charAt(sb.length() - 1)) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String leftTrim(String token, char myPaddingChar) {
        StringBuilder sb = new StringBuilder(token);
        while (sb.length() > 0 && myPaddingChar == sb.charAt(0)) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    @Override
    public String unbind(CamelContext camelContext, Map<String, Object> model) throws Exception {
        StringBuilder buffer = new StringBuilder();
        HashMap<Integer, List<String>> results = new HashMap<Integer, List<String>>();
        for (Class clazz : this.models) {
            if (!model.containsKey(clazz.getName())) continue;
            Object obj = model.get(clazz.getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Model object: {}, class: {}", obj, (Object)obj.getClass().getName());
            }
            if (obj == null) continue;
            this.generateFixedLengthPositionMap(clazz, obj, results);
        }
        TreeMap sortValues = new TreeMap(results);
        for (Map.Entry entry : sortValues.entrySet()) {
            List val = (List)entry.getValue();
            String value = (String)val.get(0);
            buffer.append(value);
        }
        return buffer.toString();
    }

    private void generateFixedLengthPositionMap(Class<?> clazz, Object obj, Map<Integer, List<String>> results) throws Exception {
        Object result = "";
        for (Field field : clazz.getDeclaredFields()) {
            List<Object> list;
            field.setAccessible(true);
            DataField datafield = field.getAnnotation(DataField.class);
            if (datafield == null) continue;
            if (obj != null) {
                int fieldLength;
                FormattingOptions formattingOptions = ConverterUtils.convert(datafield, field.getType(), field.getAnnotation(BindyConverter.class), this.getLocale());
                Format<?> format = this.formatFactory.getFormat(formattingOptions);
                Object value = field.get(obj);
                if (ObjectHelper.isNotEmpty((String)datafield.defaultValue()) && ObjectHelper.isEmpty((Object)value)) {
                    value = datafield.defaultValue();
                }
                result = this.formatString(format, value);
                if (datafield.trim()) {
                    result = ((String)result).trim();
                }
                if ((fieldLength = datafield.length()) == 0 && datafield.lengthPos() > 0) {
                    List<String> resultVals = results.get(datafield.lengthPos());
                    fieldLength = Integer.parseInt(resultVals.get(0));
                }
                if (fieldLength <= 0 && datafield.delimiter().isEmpty() && datafield.lengthPos() == 0) {
                    throw new IllegalArgumentException("Either a delimiter value or length for the field: " + field.getName() + " is mandatory.");
                }
                if (!datafield.delimiter().equals("")) {
                    result = (String)result + datafield.delimiter();
                } else {
                    String align = datafield.align();
                    char padCharField = datafield.paddingChar();
                    StringBuilder temp = new StringBuilder();
                    if (((String)result).length() < fieldLength) {
                        char padChar = padCharField == '\u0000' ? this.paddingChar : padCharField;
                        if (align.contains("R")) {
                            temp.append(this.generatePaddingChars(padChar, fieldLength, ((String)result).length()));
                            temp.append((String)result);
                        } else if (align.contains("L")) {
                            temp.append((String)result);
                            temp.append(this.generatePaddingChars(padChar, fieldLength, ((String)result).length()));
                        } else if (align.contains("B")) {
                            temp.append(this.generatePaddingChars(padChar, fieldLength, ((String)result).length()));
                            temp.append((String)result);
                        } else {
                            throw new IllegalArgumentException("Alignment for the field: " + field.getName() + " must be equal to R for RIGHT or L for LEFT or B for trimming both ends");
                        }
                        result = temp.toString();
                    } else if (((String)result).length() > fieldLength) {
                        if (datafield.clip()) {
                            result = ((String)result).substring(0, fieldLength);
                        } else {
                            throw new IllegalArgumentException("Length for the " + field.getName() + " must not be larger than allowed, was: " + ((String)result).length() + ", allowed: " + fieldLength);
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Value to be formatted: {}, position: {}, and its formatted value: {}", new Object[]{value, datafield.pos(), result});
                }
            } else {
                result = "";
            }
            Integer key = datafield.pos();
            if (!results.containsKey(key)) {
                list = new LinkedList<String>();
                list.add(result);
                results.put(key, list);
                continue;
            }
            list = results.get(key);
            list.add(result);
        }
    }

    private String generatePaddingChars(char pad, int lengthField, int lengthString) {
        StringBuilder buffer = new StringBuilder();
        int size = lengthField - lengthString;
        for (int i = 0; i < size; ++i) {
            buffer.append(Character.toString(pad));
        }
        return buffer.toString();
    }

    private void initFixedLengthRecordParameters() {
        for (Class cl : this.models) {
            FixedLengthRecord record = cl.getAnnotation(FixedLengthRecord.class);
            if (record == null) continue;
            LOG.debug("Fixed length record: {}", (Object)record);
            this.crlf = record.crlf();
            LOG.debug("Carriage return defined for the CSV: {}", (Object)this.crlf);
            this.eol = record.eol();
            LOG.debug("EOL(end-of-line) defined for the CSV: {}", (Object)this.eol);
            this.header = record.header();
            LOG.debug("Header: {}", this.header);
            this.hasHeader = this.header != Void.TYPE;
            LOG.debug("Has Header: {}", (Object)this.hasHeader);
            this.skipHeader = record.skipHeader();
            LOG.debug("Skip Header: {}", (Object)this.skipHeader);
            this.footer = record.footer();
            LOG.debug("Footer: {}", this.footer);
            this.hasFooter = record.footer() != Void.TYPE;
            LOG.debug("Has Footer: {}", (Object)this.hasFooter);
            this.skipFooter = record.skipFooter();
            LOG.debug("Skip Footer: {}", (Object)this.skipFooter);
            this.isHeader = this.hasHeader ? cl.equals(this.header) : false;
            LOG.debug("Is Header: {}", (Object)this.isHeader);
            this.isFooter = this.hasFooter ? cl.equals(this.footer) : false;
            LOG.debug("Is Footer: {}", (Object)this.isFooter);
            this.paddingChar = record.paddingChar();
            LOG.debug("Padding char: {}", (Object)Character.valueOf(this.paddingChar));
            this.recordLength = record.length();
            LOG.debug("Length of the record: {}", (Object)this.recordLength);
            this.ignoreTrailingChars = record.ignoreTrailingChars();
            LOG.debug("Ignore trailing chars: {}", (Object)this.ignoreTrailingChars);
            this.ignoreMissingChars = record.ignoreMissingChars();
            LOG.debug("Enable ignore missing chars: {}", (Object)this.ignoreMissingChars);
            this.countGrapheme = record.countGrapheme();
            LOG.debug("Enable grapheme counting instead of codepoints: {}", (Object)this.countGrapheme);
        }
        if (this.hasHeader && this.isHeader) {
            throw new IllegalArgumentException("Record can not be configured with both 'isHeader=true' and 'hasHeader=true'");
        }
        if (this.hasFooter && this.isFooter) {
            throw new IllegalArgumentException("Record can not be configured with both 'isFooter=true' and 'hasFooter=true'");
        }
        if ((this.isHeader || this.isFooter) && (this.skipHeader || this.skipFooter)) {
            throw new IllegalArgumentException("skipHeader and/or skipFooter can not be configured on a record where 'isHeader=true' or 'isFooter=true'");
        }
    }

    public Class<?> header() {
        return this.header;
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }

    public Class<?> footer() {
        return this.footer;
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    public boolean skipHeader() {
        return this.skipHeader;
    }

    public boolean skipFooter() {
        return this.skipFooter;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public boolean isFooter() {
        return this.isFooter;
    }

    public char paddingchar() {
        return this.paddingChar;
    }

    public int recordLength() {
        return this.recordLength;
    }

    public boolean isIgnoreTrailingChars() {
        return this.ignoreTrailingChars;
    }

    public boolean isIgnoreMissingChars() {
        return this.ignoreMissingChars;
    }

    public boolean isCountGrapheme() {
        return this.countGrapheme;
    }
}

