/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxTask;
import com.box.sdk.BoxTaskAssignment;
import com.box.sdk.BoxUser;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxTasksManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxTasksManager.class);
    private BoxAPIConnection boxConnection;

    public BoxTasksManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public List<BoxTask.Info> getFileTasks(String fileId) {
        try {
            LOG.debug("Getting tasks of file(id=" + fileId + ")");
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getTasks();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxTask addFileTask(String fileId, BoxTask.Action action, Date dueAt, String message) {
        try {
            LOG.debug("Adding task to file(id=" + fileId + ") to '" + message + "'");
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (action == null) {
                throw new IllegalArgumentException("Parameter 'action' can not be null");
            }
            if (dueAt == null) {
                throw new IllegalArgumentException("Parameter 'dueAt' can not be null");
            }
            BoxFile fileToAddTaskOn = new BoxFile(this.boxConnection, fileId);
            return (BoxTask)fileToAddTaskOn.addTask(action, message, dueAt).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteTask(String taskId) {
        try {
            LOG.debug("Deleting task(id=" + taskId + ")");
            if (taskId == null) {
                throw new IllegalArgumentException("Parameter 'taskId' can not be null");
            }
            BoxTask task = new BoxTask(this.boxConnection, taskId);
            task.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxTask.Info getTaskInfo(String taskId) {
        try {
            LOG.debug("Getting info for task(id=" + taskId + ")");
            if (taskId == null) {
                throw new IllegalArgumentException("Parameter 'taskId' can not be null");
            }
            BoxTask task = new BoxTask(this.boxConnection, taskId);
            return task.getInfo();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxTask updateTaskInfo(String taskId, BoxTask.Info info) {
        try {
            LOG.debug("Updating info for task(id=" + taskId + ")");
            if (taskId == null) {
                throw new IllegalArgumentException("Parameter 'taskId' can not be null");
            }
            if (info == null) {
                throw new IllegalArgumentException("Parameter 'info' can not be null");
            }
            BoxTask task = new BoxTask(this.boxConnection, taskId);
            task.updateInfo(info);
            return task;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public List<BoxTaskAssignment.Info> getTaskAssignments(String taskId) {
        try {
            LOG.debug("Getting assignments for task(id=" + taskId + ")");
            if (taskId == null) {
                throw new IllegalArgumentException("Parameter 'taskId' can not be null");
            }
            BoxTask file = new BoxTask(this.boxConnection, taskId);
            return file.getAssignments();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxTask addAssignmentToTask(String taskId, BoxUser assignTo) {
        try {
            LOG.debug("Assigning task(id=" + taskId + ") to user(id=" + assignTo.getID() + ")");
            if (taskId == null) {
                throw new IllegalArgumentException("Parameter 'commentId' can not be null");
            }
            if (assignTo == null) {
                throw new IllegalArgumentException("Parameter 'assignTo' can not be null");
            }
            BoxTask task = new BoxTask(this.boxConnection, taskId);
            task.addAssignment(assignTo);
            return task;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxTaskAssignment.Info getTaskAssignmentInfo(String taskAssignmentId) {
        try {
            LOG.debug("Getting info for task(id=" + taskAssignmentId + ")");
            if (taskAssignmentId == null) {
                throw new IllegalArgumentException("Parameter 'taskAssignmentId' can not be null");
            }
            BoxTaskAssignment taskAssignment = new BoxTaskAssignment(this.boxConnection, taskAssignmentId);
            return taskAssignment.getInfo();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteTaskAssignment(String taskAssignmentId) {
        try {
            LOG.debug("Deleting task(id=" + taskAssignmentId + ")");
            if (taskAssignmentId == null) {
                throw new IllegalArgumentException("Parameter 'taskAssignmentId' can not be null");
            }
            BoxTaskAssignment taskAssignment = new BoxTaskAssignment(this.boxConnection, taskAssignmentId);
            taskAssignment.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }
}

