/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxSharedLink;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.apache.camel.RuntimeCamelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxFoldersManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxFoldersManager.class);
    private BoxAPIConnection boxConnection;

    public BoxFoldersManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public BoxFolder getRootFolder() {
        try {
            LOG.debug("Getting root folder");
            return BoxFolder.getRootFolder((BoxAPIConnection)this.boxConnection);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxFolder getFolder(String ... path) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting folder at path={}", (Object)Arrays.toString(path));
            }
            BoxFolder folder = BoxFolder.getRootFolder((BoxAPIConnection)this.boxConnection);
            if (path == null || path.length == 0) {
                return folder;
            }
            for (int folderIndex = 0; folderIndex < path.length; ++folderIndex) {
                BoxItem.Info itemInfo2;
                block6: {
                    for (BoxItem.Info itemInfo2 : folder) {
                        if (!(itemInfo2 instanceof BoxFolder.Info) || !itemInfo2.getName().equals(path[folderIndex])) continue;
                        break block6;
                    }
                    return null;
                }
                folder = (BoxFolder)itemInfo2.getResource();
            }
            return folder;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public Collection<BoxItem.Info> getFolderItems(String folderId, Long offset, Long limit, String ... fields) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting folder items in folder(id={}) at offset={} and limit={} with fields={}", new Object[]{folderId, offset, limit, Arrays.toString(fields)});
            }
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            if (fields == null) {
                fields = new String[]{};
            }
            if (offset != null && limit != null) {
                return folder.getChildrenRange(offset.longValue(), limit.longValue(), fields);
            }
            ArrayList<BoxItem.Info> folderItems = new ArrayList<BoxItem.Info>();
            Iterable iterable = fields.length > 0 ? folder.getChildren(fields) : folder.getChildren();
            for (BoxItem.Info itemInfo : iterable) {
                folderItems.add(itemInfo);
            }
            return folderItems;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxFolder createFolder(String parentFolderId, String folderName) {
        try {
            LOG.debug("Creating folder with name '{}' in parent_folder(id={})", (Object)folderName, (Object)parentFolderId);
            if (parentFolderId == null) {
                throw new IllegalArgumentException("Parameter 'parentFolderId' can not be null");
            }
            if (folderName == null) {
                throw new IllegalArgumentException("Parameter 'folderName' can not be null");
            }
            BoxFolder parentFolder = new BoxFolder(this.boxConnection, parentFolderId);
            return parentFolder.createFolder(folderName).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxFolder createFolder(String parentFolderId, String ... path) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating folder with path '{}' in parent_folder(id={})", (Object)Arrays.toString(path), (Object)parentFolderId);
            }
            if (parentFolderId == null) {
                throw new IllegalArgumentException("Parameter 'parentFolderId' can not be null");
            }
            if (path == null) {
                throw new IllegalArgumentException("Paramerer 'path' can not be null");
            }
            BoxFolder folder = new BoxFolder(this.boxConnection, parentFolderId);
            block2: for (int folderIndex = 0; folderIndex < path.length; ++folderIndex) {
                for (BoxItem.Info itemInfo : folder) {
                    if (!(itemInfo instanceof BoxFolder.Info) || !itemInfo.getName().equals(path[folderIndex])) continue;
                    folder = (BoxFolder)itemInfo.getResource();
                    continue block2;
                }
                folder = folder.createFolder(path[folderIndex]).getResource();
            }
            return folder;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxFolder copyFolder(String folderId, String destinationFolderId, String newName) {
        try {
            LOG.debug("Copying folder(id={}) to destination_folder(id={}) {}", new Object[]{folderId, destinationFolderId, newName == null ? "" : " with new name '" + newName + "'"});
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            if (destinationFolderId == null) {
                throw new IllegalArgumentException("Parameter 'destinationFolderId' can not be null");
            }
            BoxFolder folderToCopy = new BoxFolder(this.boxConnection, folderId);
            BoxFolder destinationFolder = new BoxFolder(this.boxConnection, destinationFolderId);
            if (newName == null) {
                return folderToCopy.copy(destinationFolder).getResource();
            }
            return folderToCopy.copy(destinationFolder, newName).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxFolder moveFolder(String folderId, String destinationFolderId, String newName) {
        try {
            LOG.debug("Moving folder(id={}) to destination_folder(id={}) {}", new Object[]{folderId, destinationFolderId, newName == null ? "" : " with new name '" + newName + "'"});
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            if (destinationFolderId == null) {
                throw new IllegalArgumentException("Parameter 'destinationFolderId' can not be null");
            }
            BoxFolder folderToMove = new BoxFolder(this.boxConnection, folderId);
            BoxFolder destinationFolder = new BoxFolder(this.boxConnection, destinationFolderId);
            if (newName == null) {
                return (BoxFolder)folderToMove.move(destinationFolder).getResource();
            }
            return (BoxFolder)folderToMove.move(destinationFolder, newName).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxFolder renameFolder(String folderId, String newFolderName) {
        try {
            LOG.debug("Renaming folder(id={}}) to '{}'", (Object)folderId, (Object)newFolderName);
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            if (newFolderName == null) {
                throw new IllegalArgumentException("Parameter 'newFolderName' can not be null");
            }
            BoxFolder folderToRename = new BoxFolder(this.boxConnection, folderId);
            folderToRename.rename(newFolderName);
            return folderToRename;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public void deleteFolder(String folderId) {
        try {
            LOG.debug("Deleting folder(id={})", (Object)folderId);
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            folder.delete(true);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxFolder.Info getFolderInfo(String folderId, String ... fields) {
        try {
            LOG.debug("Getting info for folder(id={})", (Object)folderId);
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            if (fields == null || fields.length == 0) {
                return folder.getInfo();
            }
            return folder.getInfo(fields);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxFolder updateFolderInfo(String folderId, BoxFolder.Info info) {
        try {
            LOG.debug("Updating info for folder(id={})", (Object)folderId);
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            if (info == null) {
                throw new IllegalArgumentException("Parameter 'info' can not be null");
            }
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            folder.updateInfo(info);
            return folder;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public BoxSharedLink createFolderSharedLink(String folderId, BoxSharedLink.Access access, Date unshareDate, BoxSharedLink.Permissions permissions) {
        try {
            LOG.debug("Creating shared link for folder(id={}) with access={} {}", new Object[]{folderId, access, unshareDate == null ? "" : " unsharedDate=" + DateFormat.getDateTimeInstance().format(unshareDate) + " permissions=" + permissions});
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            if (access == null) {
                throw new IllegalArgumentException("Parameter 'access' can not be null");
            }
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            return folder.createSharedLink(access, unshareDate, permissions);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }
}

