/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxCollaboration;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxFolder;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxCollaborationsManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxCollaborationsManager.class);
    private BoxAPIConnection boxConnection;

    public BoxCollaborationsManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public Collection<BoxCollaboration.Info> getFolderCollaborations(String folderId) {
        try {
            LOG.debug("Getting collaborations for folder(id={})", (Object)folderId);
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            return folder.getCollaborations();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxCollaboration addFolderCollaboration(String folderId, BoxCollaborator collaborator, BoxCollaboration.Role role) {
        try {
            LOG.debug("Creating  collaborations for folder(id=" + folderId + ") with collaborator(" + collaborator.getID() + ")");
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            if (collaborator == null) {
                throw new IllegalArgumentException("Parameter 'collaborator' can not be null");
            }
            if (role == null) {
                throw new IllegalArgumentException("Parameter 'role' can not be null");
            }
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            return folder.collaborate(collaborator, role).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxCollaboration addFolderCollaborationByEmail(String folderId, String email, BoxCollaboration.Role role) {
        try {
            LOG.debug("Creating  collaborations for folder(id=" + folderId + ") with collaborator(" + email + ")");
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            if (email == null) {
                throw new IllegalArgumentException("Parameter 'email' can not be null");
            }
            if (role == null) {
                throw new IllegalArgumentException("Parameter 'role' can not be null");
            }
            BoxFolder folder = new BoxFolder(this.boxConnection, folderId);
            return folder.collaborate(email, role).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxCollaboration.Info getCollaborationInfo(String collaborationId) {
        try {
            LOG.debug("Getting info for collaboration(id={})", (Object)collaborationId);
            if (collaborationId == null) {
                throw new IllegalArgumentException("Parameter 'collaborationId' can not be null");
            }
            BoxCollaboration collaboration = new BoxCollaboration(this.boxConnection, collaborationId);
            return collaboration.getInfo();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxCollaboration updateCollaborationInfo(String collaborationId, BoxCollaboration.Info info) {
        try {
            LOG.debug("Updating info for collaboration(id={})", (Object)collaborationId);
            if (collaborationId == null) {
                throw new IllegalArgumentException("Parameter 'collaborationId' can not be null");
            }
            BoxCollaboration collaboration = new BoxCollaboration(this.boxConnection, collaborationId);
            collaboration.updateInfo(info);
            return collaboration;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteCollaboration(String collaborationId) {
        try {
            LOG.debug("Deleting collaboration(id={})", (Object)collaborationId);
            if (collaborationId == null) {
                throw new IllegalArgumentException("Parameter 'collaborationId' can not be null");
            }
            BoxCollaboration collaboration = new BoxCollaboration(this.boxConnection, collaborationId);
            collaboration.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public Collection<BoxCollaboration.Info> getPendingCollaborations() {
        try {
            return BoxCollaboration.getPendingCollaborations((BoxAPIConnection)this.boxConnection);
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }
}

