/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxTask;
import com.box.sdk.BoxTaskAssignment;
import com.box.sdk.BoxUser;
import java.util.Date;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.api.BoxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxTasksManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxTasksManager.class);
    private BoxAPIConnection boxConnection;

    public BoxTasksManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public List<BoxTask.Info> getFileTasks(String fileId) {
        try {
            LOG.debug("Getting tasks of file(id={})", (Object)fileId);
            BoxHelper.notNull(fileId, "fileId");
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getTasks(new String[0]);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxTask addFileTask(String fileId, BoxTask.Action action, Date dueAt, String message) {
        try {
            LOG.debug("Adding task to file(id={}) to '{}'", (Object)fileId, (Object)message);
            BoxHelper.notNull(fileId, "fileId");
            BoxHelper.notNull(action, "action");
            BoxHelper.notNull(dueAt, "dueAt");
            BoxFile fileToAddTaskOn = new BoxFile(this.boxConnection, fileId);
            return fileToAddTaskOn.addTask(action, message, dueAt).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public void deleteTask(String taskId) {
        try {
            LOG.debug("Deleting task(id={})", (Object)taskId);
            BoxHelper.notNull(taskId, "taskId");
            BoxTask task = new BoxTask(this.boxConnection, taskId);
            task.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxTask.Info getTaskInfo(String taskId) {
        try {
            LOG.debug("Getting info for task(id={})", (Object)taskId);
            BoxHelper.notNull(taskId, "taskId");
            BoxTask task = new BoxTask(this.boxConnection, taskId);
            return task.getInfo(new String[0]);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxTask updateTaskInfo(String taskId, BoxTask.Info info) {
        try {
            LOG.debug("Updating info for task(id={})", (Object)taskId);
            BoxHelper.notNull(taskId, "taskId");
            BoxHelper.notNull(info, "info");
            BoxTask task = new BoxTask(this.boxConnection, taskId);
            task.updateInfo(info);
            return task;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public List<BoxTaskAssignment.Info> getTaskAssignments(String taskId) {
        try {
            LOG.debug("Getting assignments for task(id={})", (Object)taskId);
            BoxHelper.notNull(taskId, "taskId");
            BoxTask file = new BoxTask(this.boxConnection, taskId);
            return file.getAssignments();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxTask addAssignmentToTask(String taskId, BoxUser assignTo) {
        try {
            BoxHelper.notNull(taskId, "taskId");
            BoxHelper.notNull(assignTo, "assignTo");
            LOG.debug("Assigning task(id={}) to user(id={})", (Object)taskId, (Object)assignTo.getID());
            BoxTask task = new BoxTask(this.boxConnection, taskId);
            task.addAssignment(assignTo);
            return task;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxTaskAssignment.Info getTaskAssignmentInfo(String taskAssignmentId) {
        try {
            LOG.debug("Getting info for task(id={})", (Object)taskAssignmentId);
            BoxHelper.notNull(taskAssignmentId, "taskAssignmentId");
            BoxTaskAssignment taskAssignment = new BoxTaskAssignment(this.boxConnection, taskAssignmentId);
            return taskAssignment.getInfo();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public void deleteTaskAssignment(String taskAssignmentId) {
        try {
            LOG.debug("Deleting task(id={})", (Object)taskAssignmentId);
            BoxHelper.notNull(taskAssignmentId, "taskAssignmentId");
            BoxTaskAssignment taskAssignment = new BoxTaskAssignment(this.boxConnection, taskAssignmentId);
            taskAssignment.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }
}

