/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.braintree;

import com.braintreegateway.BraintreeGateway;
import com.braintreegateway.Environment;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class BraintreeConfiguration {
    private static final String ENVIRONMENT = "environment";
    private static final String MERCHANT_ID = "merchant_id";
    private static final String PUBLIC_KEY = "public_key";
    private static final String PRIVATE_KEY = "private_key";
    @UriParam
    @Metadata(required="true")
    private String environment;
    @UriParam
    @Metadata(required="true")
    private String merchantId;
    @UriParam
    @Metadata(required="true")
    private String publicKey;
    @UriParam
    @Metadata(required="true")
    private String privateKey;
    @UriParam
    @Metadata(label="proxy")
    private String proxyHost;
    @UriParam
    @Metadata(label="proxy")
    private Integer proxyPort;

    public String getEnvironment() {
        return (String)ObjectHelper.notNull((Object)this.environment, (String)ENVIRONMENT);
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getMerchantId() {
        return (String)ObjectHelper.notNull((Object)this.merchantId, (String)MERCHANT_ID);
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getPublicKey() {
        return (String)ObjectHelper.notNull((Object)this.publicKey, (String)PUBLIC_KEY);
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return (String)ObjectHelper.notNull((Object)this.privateKey, (String)PRIVATE_KEY);
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    private Environment getBraintreeEnvironment() {
        String name = this.getEnvironment();
        if (Environment.DEVELOPMENT.getEnvironmentName().equalsIgnoreCase(name)) {
            return Environment.DEVELOPMENT;
        }
        if (Environment.SANDBOX.getEnvironmentName().equalsIgnoreCase(name)) {
            return Environment.SANDBOX;
        }
        if (Environment.PRODUCTION.getEnvironmentName().equalsIgnoreCase(name)) {
            return Environment.PRODUCTION;
        }
        throw new IllegalArgumentException(String.format("Environment should be development, sandbox or production, got %s", name));
    }

    BraintreeGateway newBraintreeGateway() {
        BraintreeGateway gateway = new BraintreeGateway(this.getBraintreeEnvironment(), this.getMerchantId(), this.getPublicKey(), this.getPrivateKey());
        if (ObjectHelper.isNotEmpty((Object)this.proxyHost) && ObjectHelper.isNotEmpty((Object)this.proxyPort)) {
            gateway.setProxy(this.proxyHost, this.proxyPort);
        }
        return gateway;
    }
}

