/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.braintree;

import com.braintreegateway.BraintreeGateway;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.braintree.BraintreeComponent;
import org.apache.camel.component.braintree.BraintreeConfiguration;
import org.apache.camel.component.braintree.BraintreeProducer;
import org.apache.camel.component.braintree.internal.BraintreeApiCollection;
import org.apache.camel.component.braintree.internal.BraintreeApiName;
import org.apache.camel.component.braintree.internal.BraintreePropertiesHelper;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;

@UriEndpoint(firstVersion="2.17.0", scheme="braintree", title="Braintree", syntax="braintree:apiName/methodName", producerOnly=true, apiSyntax="apiName/methodName", category={Category.CLOUD, Category.PAYMENT})
public class BraintreeEndpoint
extends AbstractApiEndpoint<BraintreeApiName, BraintreeConfiguration> {
    @UriParam
    private final BraintreeConfiguration configuration;
    private Object apiProxy;

    public BraintreeEndpoint(String uri, BraintreeComponent component, BraintreeApiName apiName, String methodName, BraintreeConfiguration configuration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, BraintreeApiCollection.getCollection().getHelper(apiName), (Object)configuration);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new BraintreeProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public BraintreeComponent getComponent() {
        return (BraintreeComponent)super.getComponent();
    }

    protected ApiMethodPropertiesHelper<BraintreeConfiguration> getPropertiesHelper() {
        return BraintreePropertiesHelper.getHelper(this.getCamelContext());
    }

    protected String getThreadProfileName() {
        return "CamelBraintree";
    }

    protected void afterConfigureProperties() {
        BraintreeGateway gateway = this.getComponent().getGateway(this.configuration);
        try {
            Method method = gateway.getClass().getMethod(((BraintreeApiName)this.apiName).getName(), new Class[0]);
            this.apiProxy = method.invoke((Object)gateway, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.apiProxy;
    }
}

