/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.cache;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.cache.CaffeineCacheEndpoint;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.support.HeaderSelectorProducer;

public class CaffeineCacheProducer
extends HeaderSelectorProducer {
    private final CaffeineConfiguration configuration;
    private final Cache cache;

    public CaffeineCacheProducer(CaffeineCacheEndpoint endpoint, String cacheName, CaffeineConfiguration configuration, Cache cache) throws Exception {
        super((Endpoint)endpoint, "CamelCaffeineAction", configuration::getAction);
        this.configuration = configuration;
        this.cache = cache;
    }

    @InvokeOnHeader(value="CLEANUP")
    public void onCleanUp(Message message) throws Exception {
        this.cache.cleanUp();
        this.setResult(message, true, null, null);
    }

    @InvokeOnHeader(value="PUT")
    public void onPut(Message message) throws Exception {
        this.cache.put(this.getKey(message), this.getValue(message, this.configuration.getValueType()));
        this.setResult(message, true, null, null);
    }

    @InvokeOnHeader(value="PUT_ALL")
    public void onPutAll(Message message) throws Exception {
        this.cache.putAll((Map)this.getValue(message, Map.class.getName()));
        this.setResult(message, true, null, null);
    }

    @InvokeOnHeader(value="GET")
    public void onGet(Message message) throws Exception {
        Object result = this.cache.getIfPresent(this.getKey(message));
        this.setResult(message, true, result, null);
    }

    @InvokeOnHeader(value="GET_ALL")
    public void onGetAll(Message message) throws Exception {
        Map result = this.cache.getAllPresent((Iterable)message.getHeader("CamelCaffeineKeys", Collections::emptySet, Set.class));
        this.setResult(message, true, result, null);
    }

    @InvokeOnHeader(value="INVALIDATE")
    public void onInvalidate(Message message) throws Exception {
        this.cache.invalidate(this.getKey(message));
        this.setResult(message, true, null, null);
    }

    @InvokeOnHeader(value="INVALIDATE_ALL")
    public void onInvalidateAll(Message message) throws Exception {
        this.cache.invalidateAll((Iterable)message.getHeader("CamelCaffeineKeys", Collections::emptySet, Set.class));
        this.setResult(message, true, null, null);
    }

    private Object getKey(Message message) throws Exception {
        Object value;
        if (this.configuration.getKeyType() != null) {
            Class clazz = this.getEndpoint().getCamelContext().getClassResolver().resolveClass(this.configuration.getKeyType());
            value = message.getHeader("CamelCaffeineKey", clazz);
        } else {
            value = message.getHeader("CamelCaffeineKey");
        }
        if (value == null) {
            value = this.configuration.getKey();
        }
        if (value == null) {
            throw new CamelExchangeException("No value provided in header or as default value (CamelCaffeineKey)", message.getExchange());
        }
        return value;
    }

    private Object getValue(Message message, String type) throws Exception {
        Object value = message.getHeader("CamelCaffeineValue");
        if (value == null) {
            if (type != null) {
                Class clazz = this.getEndpoint().getCamelContext().getClassResolver().resolveClass(type);
                value = message.getBody(clazz);
            } else {
                value = message.getBody();
            }
        }
        if (value == null) {
            throw new CamelExchangeException("No value provided in header or body (CamelCaffeineValue)", message.getExchange());
        }
        return value;
    }

    private void setResult(Message message, boolean success, Object result, Object oldValue) {
        message.setHeader("CamelCaffeineActionSucceeded", (Object)success);
        message.setHeader("CamelCaffeineActionHasResult", (Object)(oldValue != null || result != null ? 1 : 0));
        if (oldValue != null) {
            message.setHeader("CamelCaffeineOldValue", oldValue);
        }
        if (result != null) {
            message.setBody(result);
        }
    }
}

