/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.load;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.EvictionType;
import org.apache.camel.component.caffeine.load.CaffeineLoadCacheComponent;
import org.apache.camel.component.caffeine.load.CaffeineLoadCacheProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.20.0", scheme="caffeine-loadcache", title="Caffeine LoadCache", syntax="caffeine-loadcache:cacheName", category={Category.CACHE, Category.DATAGRID, Category.CLUSTERING}, producerOnly=true)
public class CaffeineLoadCacheEndpoint
extends DefaultEndpoint {
    @UriPath(description="the cache name")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final CaffeineConfiguration configuration;
    private LoadingCache cache;

    CaffeineLoadCacheEndpoint(String uri, CaffeineLoadCacheComponent component, String cacheName, CaffeineConfiguration configuration) throws Exception {
        super(uri, (Component)component);
        this.cacheName = cacheName;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new CaffeineLoadCacheProducer(this, this.cacheName, this.configuration, this.cache);
    }

    protected void doStart() throws Exception {
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getCache())) {
            this.cache = (LoadingCache)this.configuration.getCache();
        } else {
            Caffeine builder = Caffeine.newBuilder();
            if (this.configuration.getEvictionType() == EvictionType.SIZE_BASED) {
                builder.initialCapacity(this.configuration.getInitialCapacity());
                builder.maximumSize((long)this.configuration.getMaximumSize());
            } else if (this.configuration.getEvictionType() == EvictionType.TIME_BASED) {
                builder.expireAfterAccess((long)this.configuration.getExpireAfterAccessTime(), TimeUnit.SECONDS);
                builder.expireAfterWrite((long)this.configuration.getExpireAfterWriteTime(), TimeUnit.SECONDS);
            }
            if (this.configuration.isStatsEnabled()) {
                if (ObjectHelper.isEmpty((Object)this.configuration.getStatsCounter())) {
                    builder.recordStats();
                } else {
                    builder.recordStats(() -> this.configuration.getStatsCounter());
                }
            }
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getRemovalListener())) {
                builder.removalListener(this.configuration.getRemovalListener());
            }
            this.cache = builder.build(this.configuration.getCacheLoader());
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    CaffeineConfiguration getConfiguration() {
        return this.configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new IllegalArgumentException("The caffeine-loadcache component doesn't support consumer");
    }
}

