/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.cache;

import com.github.benmanes.caffeine.cache.Cache;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.CaffeineConstants;
import org.apache.camel.component.caffeine.cache.CaffeineCacheComponent;
import org.apache.camel.component.caffeine.cache.CaffeineCacheProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.20.0", scheme="caffeine-cache", title="Caffeine Cache", syntax="caffeine-cache:cacheName", category={Category.CACHE, Category.CLUSTERING}, producerOnly=true, headersClass=CaffeineConstants.class)
public class CaffeineCacheEndpoint
extends DefaultEndpoint {
    @UriPath(description="Cache name")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final CaffeineConfiguration configuration;
    private volatile Cache<?, ?> cache;

    CaffeineCacheEndpoint(String uri, Component component, String cacheName, CaffeineConfiguration configuration) {
        super(uri, component);
        this.cacheName = cacheName;
        this.configuration = configuration;
    }

    public CaffeineCacheComponent getComponent() {
        return (CaffeineCacheComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        return new CaffeineCacheProducer(this, this.configuration, this.cache);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.cache = (Cache)CamelContextHelper.lookup((CamelContext)this.getCamelContext(), (String)this.cacheName, Cache.class);
        if (this.cache == null) {
            if (this.configuration.isCreateCacheIfNotExist()) {
                this.cache = this.getComponent().getOrCreateCache(this.cacheName, this.configuration);
            } else {
                throw new IllegalArgumentException("Cache instance '" + this.cacheName + "' not found and createCacheIfNotExist is set to false");
            }
        }
    }

    CaffeineConfiguration getConfiguration() {
        return this.configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new IllegalArgumentException("The caffeine-cache component doesn't support consumer");
    }
}

