/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.cassandra.CassandraEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;

public class CassandraConsumer
extends ScheduledPollConsumer {
    private PreparedStatement preparedStatement;

    public CassandraConsumer(CassandraEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public CassandraEndpoint getEndpoint() {
        return (CassandraEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        CqlSession session = this.getEndpoint().getSessionHolder().getSession();
        ResultSet resultSet = this.isPrepareStatements() ? session.execute((Statement)this.preparedStatement.bind(new Object[0])) : session.execute(this.getEndpoint().getCql());
        Exchange exchange = this.getEndpoint().createExchange();
        Message message = exchange.getIn();
        this.getEndpoint().fillMessage(resultSet, message);
        try {
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.isPrepareStatements()) {
            this.preparedStatement = this.getEndpoint().prepareStatement();
        }
    }

    protected void doStop() throws Exception {
        this.preparedStatement = null;
        super.doStop();
    }

    public boolean isPrepareStatements() {
        return this.getEndpoint().isPrepareStatements();
    }
}

