/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cassandra;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.component.cassandra.ResultSetConversionStrategy;

public final class ResultSetConversionStrategies {
    private static final Pattern LIMIT_NAME_PATTERN = Pattern.compile("^LIMIT_(\\d+)$", 2);
    private static final ResultSetConversionStrategy ALL = new ResultSetConversionStrategy(){

        @Override
        public Object getBody(ResultSet resultSet) {
            return resultSet.all();
        }
    };
    private static final ResultSetConversionStrategy ONE = new ResultSetConversionStrategy(){

        @Override
        public Object getBody(ResultSet resultSet) {
            return resultSet.one();
        }
    };

    private ResultSetConversionStrategies() {
    }

    public static ResultSetConversionStrategy all() {
        return ALL;
    }

    public static ResultSetConversionStrategy one() {
        return ONE;
    }

    public static ResultSetConversionStrategy limit(int rowMax) {
        return new LimitResultSetConversionStrategy(rowMax);
    }

    public static ResultSetConversionStrategy fromName(String name) {
        if (name == null) {
            return null;
        }
        if (name.equalsIgnoreCase("ALL")) {
            return ResultSetConversionStrategies.all();
        }
        if (name.equalsIgnoreCase("ONE")) {
            return ResultSetConversionStrategies.one();
        }
        Matcher matcher = LIMIT_NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            int limit = Integer.parseInt(matcher.group(1));
            return ResultSetConversionStrategies.limit(limit);
        }
        throw new IllegalArgumentException("Unknown conversion strategy " + name);
    }

    private static class LimitResultSetConversionStrategy
    implements ResultSetConversionStrategy {
        private final int rowMax;

        LimitResultSetConversionStrategy(int rowMax) {
            this.rowMax = rowMax;
        }

        @Override
        public Object getBody(ResultSet resultSet) {
            ArrayList rows = new ArrayList(this.rowMax);
            Iterator rowIter = resultSet.iterator();
            for (int rowCount = 0; rowIter.hasNext() && rowCount < this.rowMax; ++rowCount) {
                rows.add(rowIter.next());
            }
            return rows;
        }
    }
}

