/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cassandra;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CassandraEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":beanRef:hosts:port/keyspace";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "cql".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "beanRef", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "hosts", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "keyspace", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(35);
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("beanRef");
        props.add("bridgeErrorHandler");
        props.add("clusterName");
        props.add("consistencyLevel");
        props.add("cql");
        props.add("datacenter");
        props.add("delay");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("extraTypeCodecs");
        props.add("greedy");
        props.add("hosts");
        props.add("initialDelay");
        props.add("keyspace");
        props.add("lazyStartProducer");
        props.add("loadBalancingPolicyClass");
        props.add("password");
        props.add("pollStrategy");
        props.add("port");
        props.add("prepareStatements");
        props.add("repeatCount");
        props.add("resultSetConversionStrategy");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("sendEmptyMessageWhenIdle");
        props.add("session");
        props.add("startScheduler");
        props.add("timeUnit");
        props.add("useFixedDelay");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

