/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.common;

import java.io.File;
import java.util.Set;
import org.apache.camel.catalog.common.FileUtil;
import org.apache.camel.support.PatternHelper;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

public final class CatalogHelper {
    private CatalogHelper() {
    }

    public static String asRelativeFile(String name, MavenProject project) {
        String answer = name;
        String base = project.getBasedir().getAbsolutePath();
        if (name.startsWith(base) && (answer = name.substring(base.length())).startsWith(File.separator)) {
            answer = answer.substring(1);
        }
        return answer;
    }

    public static String stripRootPath(String name, MavenProject project) {
        String dir;
        for (String dir2 : project.getCompileSourceRoots()) {
            if (!name.startsWith(dir2 = CatalogHelper.asRelativeFile(dir2, project))) continue;
            return name.substring(dir2.length() + 1);
        }
        for (String dir2 : project.getTestCompileSourceRoots()) {
            if (!name.startsWith(dir2 = CatalogHelper.asRelativeFile(dir2, project))) continue;
            return name.substring(dir2.length() + 1);
        }
        for (Resource resource : project.getResources()) {
            dir = CatalogHelper.asRelativeFile(resource.getDirectory(), project);
            if (!name.startsWith(dir)) continue;
            return name.substring(dir.length() + 1);
        }
        for (Resource resource : project.getTestResources()) {
            dir = CatalogHelper.asRelativeFile(resource.getDirectory(), project);
            if (!name.startsWith(dir)) continue;
            return name.substring(dir.length() + 1);
        }
        return name;
    }

    public static boolean fileListMatchesPattern(String fileList, File file, MavenProject project) {
        for (String fileName : fileList.split(",")) {
            boolean match;
            fileName = fileName.trim();
            String fqn = CatalogHelper.stripRootPath(CatalogHelper.asRelativeFile(file.getAbsolutePath(), project), project);
            boolean bl = match = PatternHelper.matchPattern((String)fqn, (String)fileName) || PatternHelper.matchPattern((String)file.getName(), (String)fileName);
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static void findXmlFiles(File dir, Set<File> xmlFiles) {
        FileUtil.findXmlFiles(dir, xmlFiles);
    }

    public static boolean matchRouteFile(File file, String excludes, String includes, MavenProject project) {
        if (excludes == null && includes == null) {
            return true;
        }
        if (excludes != null && CatalogHelper.fileListMatchesPattern(excludes, file, project)) {
            return false;
        }
        if (includes != null) {
            return CatalogHelper.fileListMatchesPattern(includes, file, project);
        }
        return true;
    }

    public static void findJavaRouteBuilderClasses(Set<File> javaFiles, boolean includeJava, boolean includeTest, MavenProject project) {
        if (includeJava) {
            for (String dir : project.getCompileSourceRoots()) {
                FileUtil.findJavaFiles(new File(dir), javaFiles);
            }
            if (includeTest) {
                for (String dir : project.getTestCompileSourceRoots()) {
                    FileUtil.findJavaFiles(new File(dir), javaFiles);
                }
            }
        }
    }

    public static void findXmlRouters(Set<File> xmlFiles, boolean includeXml, boolean includeTest, MavenProject project) {
        if (includeXml) {
            for (Resource dir : project.getResources()) {
                CatalogHelper.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
            }
            if (includeTest) {
                for (Resource dir : project.getTestResources()) {
                    CatalogHelper.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
                }
            }
        }
    }
}

