/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.console;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="catalog")
public class CatalogConsole
extends AbstractDevConsole {
    private static final String CP = System.getProperty("java.class.path");
    private final CamelCatalog catalog = new DefaultCamelCatalog(true);

    public CatalogConsole() {
        super("camel", "catalog", "Catalog", "Lists all the used Camel Components");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nComponents:\n");
        this.getCamelContext().getComponentNames().forEach(n -> CatalogConsole.appendModel(this.catalog.componentModel(n), sb));
        sb.append("\n\nLanguages:\n");
        this.getCamelContext().getLanguageNames().forEach(n -> CatalogConsole.appendModel(this.catalog.languageModel(n), sb));
        sb.append("\n\nData Formats:\n");
        this.getCamelContext().getDataFormatNames().forEach(n -> CatalogConsole.appendModel(this.catalog.dataFormatModel(n), sb));
        sb.append("\n\nMiscellaneous Components:\n");
        String[] cp = CP.split("[:|;]");
        String suffix = "-" + this.getCamelContext().getVersion() + ".jar";
        for (String c : cp) {
            int pos;
            if (!c.endsWith(suffix) || (pos = Math.max(c.lastIndexOf("/"), c.lastIndexOf("\\"))) <= 0) continue;
            c = c.substring(pos + 1, c.length() - suffix.length());
            CatalogConsole.appendModel(this.findOtherModel(c), sb);
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ArrayList components = new ArrayList();
        root.put((Object)"components", components);
        ArrayList dataformat = new ArrayList();
        root.put((Object)"dataformat", dataformat);
        ArrayList languages = new ArrayList();
        root.put((Object)"languages", languages);
        ArrayList<JsonObject> others = new ArrayList<JsonObject>();
        root.put((Object)"others", others);
        this.getCamelContext().getComponentNames().forEach(n -> CatalogConsole.appendModel(this.catalog.componentModel(n), components));
        this.getCamelContext().getLanguageNames().forEach(n -> CatalogConsole.appendModel(this.catalog.languageModel(n), languages));
        this.getCamelContext().getDataFormatNames().forEach(n -> CatalogConsole.appendModel(this.catalog.dataFormatModel(n), dataformat));
        String[] cp = CP.split("[:|;]");
        String suffix = "-" + this.getCamelContext().getVersion() + ".jar";
        for (String c : cp) {
            int pos;
            if (!c.endsWith(suffix) || (pos = Math.max(c.lastIndexOf("/"), c.lastIndexOf("\\"))) <= 0) continue;
            c = c.substring(pos + 1, c.length() - suffix.length());
            CatalogConsole.appendModel(this.findOtherModel(c), others);
        }
        return root;
    }

    private ArtifactModel findOtherModel(String artifactId) {
        for (String name : this.catalog.findOtherNames()) {
            OtherModel model = this.catalog.otherModel(name);
            if (model == null || !model.getArtifactId().equals(artifactId)) continue;
            return model;
        }
        return null;
    }

    private static void appendModel(ArtifactModel<?> model, StringBuilder sb) {
        if (model != null) {
            Object level = model.getSupportLevel().toString();
            if (model.isDeprecated()) {
                level = (String)level + "-deprecated";
            }
            sb.append(String.format("\n    %s %s %s %s: %s", model.getArtifactId(), level, model.getFirstVersionShort(), model.getTitle(), model.getDescription()));
        }
    }

    private static void appendModel(ArtifactModel<?> model, List<JsonObject> list) {
        if (model != null) {
            JsonObject jo = new JsonObject();
            Object level = model.getSupportLevel().toString();
            if (model.isDeprecated()) {
                level = (String)level + "-deprecated";
            }
            jo.put((Object)"groupId", (Object)model.getGroupId());
            jo.put((Object)"artifactId", (Object)model.getArtifactId());
            jo.put((Object)"version", (Object)model.getVersion());
            jo.put((Object)"level", level);
            jo.put((Object)"firstVersion", (Object)model.getFirstVersionShort());
            jo.put((Object)"title", (Object)model.getTitle());
            jo.put((Object)"description", (Object)model.getDescription());
            list.add(jo);
        }
    }
}

