/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.suggest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.camel.catalog.SuggestionStrategy;
import org.apache.commons.codec.language.Soundex;

public class CatalogSuggestionStrategy
implements SuggestionStrategy {
    private static final int MAX_SUGGESTIONS = 5;

    public String[] suggestEndpointOptions(Set<String> names, String unknownOption) {
        return CatalogSuggestionStrategy.suggestEndpointOptions(names, unknownOption, 5);
    }

    public static String[] suggestEndpointOptions(Collection<String> names, String unknownOption, int maxSuggestions) {
        ArrayList<String> answer = new ArrayList<String>();
        Soundex soundex = Soundex.US_ENGLISH_SIMPLIFIED;
        ArrayList<String> sort = new ArrayList<String>(names);
        Collections.sort(sort);
        try {
            int value;
            for (String name : sort) {
                value = soundex.difference(unknownOption, name);
                if (value != 4 || answer.size() >= maxSuggestions) continue;
                answer.add(name);
            }
            for (String name : sort) {
                value = soundex.difference(unknownOption, name);
                if (value != 3 || answer.size() >= maxSuggestions || answer.contains(name)) continue;
                answer.add(name);
            }
            if (answer.size() < maxSuggestions && unknownOption.length() >= 4) {
                unknownOption = unknownOption.toLowerCase(Locale.ROOT);
                for (String name : sort) {
                    String lower = name.toLowerCase(Locale.ROOT);
                    if (answer.size() >= maxSuggestions || !lower.startsWith(unknownOption) || answer.contains(name)) continue;
                    answer.add(name);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer.toArray(new String[0]);
    }
}

