/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

public final class JSonSchemaHelper {
    private JSonSchemaHelper() {
    }

    public static List<Map<String, String>> parseJsonSchema(String group, String json, boolean parseProperties) {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (json == null) {
            return answer;
        }
        try {
            JsonObject output = (JsonObject)Jsoner.deserialize(json);
            for (String key : output.keySet()) {
                Object row = output.getMap(key);
                if (!key.equals(group)) continue;
                if (parseProperties) {
                    Iterator iterator = row.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry obj;
                        Map.Entry entry = obj = iterator.next();
                        LinkedHashMap<String, String> newRow = new LinkedHashMap<String, String>();
                        newRow.put("name", entry.getKey().toString());
                        Map<String, String> newData = JSonSchemaHelper.transformMap((Map)entry.getValue());
                        newRow.putAll(newData);
                        answer.add(newRow);
                    }
                    continue;
                }
                Map<String, String> newData = JSonSchemaHelper.transformMap(row);
                Iterator<Map.Entry<String, String>> iterator = newData.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> obj;
                    Map.Entry<String, String> entry = obj = iterator.next();
                    LinkedHashMap<String, String> newRow = new LinkedHashMap<String, String>();
                    newRow.put(entry.getKey().toString(), entry.getValue().toString());
                    answer.add(newRow);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse json", e);
        }
        return answer;
    }

    private static Map<String, String> transformMap(Map jsonMap) {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (Map.Entry rowObj : jsonMap.entrySet()) {
            Map.Entry rowEntry = rowObj;
            Object newValue = rowEntry.getValue();
            if (newValue instanceof List) {
                List list = (List)newValue;
                newValue = list.stream().map(Object::toString).collect(Collectors.joining(","));
            }
            String value = JSonSchemaHelper.escapeJson(newValue.toString());
            answer.put(rowEntry.getKey().toString(), value);
        }
        return answer;
    }

    private static String escapeJson(String value) {
        return value.replaceAll("\\\\r", "\\\\\\r").replaceAll("\\\\n", "\\\\\\n").replaceAll("\\\\t", "\\\\\\t");
    }

    public static boolean isComponentLenientProperties(List<Map<String, String>> rows) {
        for (Map<String, String> row : rows) {
            if (!row.containsKey("lenientProperties")) continue;
            return "true".equals(row.get("lenientProperties"));
        }
        return false;
    }

    public static boolean isComponentConsumerOnly(List<Map<String, String>> rows) {
        for (Map<String, String> row : rows) {
            if (!row.containsKey("consumerOnly")) continue;
            return "true".equals(row.get("consumerOnly"));
        }
        return false;
    }

    public static boolean isComponentProducerOnly(List<Map<String, String>> rows) {
        for (Map<String, String> row : rows) {
            if (!row.containsKey("producerOnly")) continue;
            return "true".equals(row.get("producerOnly"));
        }
        return false;
    }

    public static boolean isPropertyConsumerOnly(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String labels = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("label")) {
                labels = row.get("label");
            }
            if (!found) continue;
            return labels != null && labels.contains("consumer");
        }
        return false;
    }

    public static boolean isPropertyProducerOnly(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String labels = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("label")) {
                labels = row.get("label");
            }
            if (!found) continue;
            return labels != null && labels.contains("producer");
        }
        return false;
    }

    public static boolean isPropertyRequired(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            boolean required = false;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("required")) {
                required = "true".equals(row.get("required"));
            }
            if (!found) continue;
            return required;
        }
        return false;
    }

    public static boolean isPropertyDeprecated(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            boolean deprecated = false;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("deprecated")) {
                deprecated = "true".equals(row.get("deprecated"));
            }
            if (!found) continue;
            return deprecated;
        }
        return false;
    }

    public static String getPropertyKind(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String kind = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("kind")) {
                kind = row.get("kind");
            }
            if (!found) continue;
            return kind;
        }
        return null;
    }

    public static boolean isPropertyBoolean(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String type = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("type")) {
                type = row.get("type");
            }
            if (!found) continue;
            return "boolean".equals(type);
        }
        return false;
    }

    public static boolean isPropertyInteger(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String type = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("type")) {
                type = row.get("type");
            }
            if (!found) continue;
            return "integer".equals(type);
        }
        return false;
    }

    public static boolean isPropertyNumber(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String type = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("type")) {
                type = row.get("type");
            }
            if (!found) continue;
            return "number".equals(type);
        }
        return false;
    }

    public static boolean isPropertyObject(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String type = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("type")) {
                type = row.get("type");
            }
            if (!found) continue;
            return "object".equals(type);
        }
        return false;
    }

    public static String getPropertyDefaultValue(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String defaultValue = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("defaultValue")) {
                defaultValue = row.get("defaultValue");
            }
            if (!found) continue;
            return defaultValue;
        }
        return null;
    }

    public static String stripOptionalPrefixFromName(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String optionalPrefix = null;
            boolean found = false;
            if (row.containsKey("optionalPrefix")) {
                optionalPrefix = row.get("optionalPrefix");
            }
            if (row.containsKey("name")) {
                if (optionalPrefix != null && name.startsWith(optionalPrefix)) {
                    name = name.substring(optionalPrefix.length());
                    return JSonSchemaHelper.stripOptionalPrefixFromName(rows, name);
                }
                found = name.equals(row.get("name"));
            }
            if (!found) continue;
            return name;
        }
        return name;
    }

    public static String getPropertyEnum(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String enums = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("enum")) {
                enums = row.get("enum");
            }
            if (!found) continue;
            return enums;
        }
        return null;
    }

    public static String getPropertyPrefix(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String prefix = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("prefix")) {
                prefix = row.get("prefix");
            }
            if (!found) continue;
            return prefix;
        }
        return null;
    }

    public static boolean isPropertyMultiValue(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            boolean multiValue = false;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("multiValue")) {
                multiValue = "true".equals(row.get("multiValue"));
            }
            if (!found) continue;
            return multiValue;
        }
        return false;
    }

    public static String getPropertyNameFromNameWithPrefix(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String propertyName = null;
            boolean found = false;
            if (row.containsKey("name")) {
                propertyName = row.get("name");
            }
            if (row.containsKey("prefix")) {
                String preifx = row.get("prefix");
                found = name.startsWith(preifx);
            }
            if (!found) continue;
            return propertyName;
        }
        return null;
    }

    public static Map<String, String> getRow(List<Map<String, String>> rows, String key) {
        for (Map<String, String> row : rows) {
            if (!key.equals(row.get("name"))) continue;
            return row;
        }
        return null;
    }

    public static Set<String> getNames(List<Map<String, String>> rows) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        for (Map<String, String> row : rows) {
            if (!row.containsKey("name")) continue;
            answer.add(row.get("name"));
        }
        return answer;
    }
}

