/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.control.RequestContextController;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.main.MainCommandLineSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
public class Main
extends MainCommandLineSupport {
    private static final Logger LOG;
    private static Main instance;
    private boolean startContexts = true;
    private SeContainer cdiContainer;
    private Runnable stopHook;

    public static void main(String ... args) throws Exception {
        Main main;
        instance = main = new Main();
        try {
            main.run(args);
        }
        finally {
            instance = null;
        }
    }

    public static Main getInstance() {
        return instance;
    }

    public Main setStartContexts(boolean startContexts) {
        this.startContexts = startContexts;
        return this;
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        if (this.getCamelContext() == null) {
            throw new IllegalArgumentException("No CamelContext are available so cannot create a ProducerTemplate!");
        }
        return this.getCamelContext().createProducerTemplate();
    }

    protected CamelContext createCamelContext() {
        BeanManager manager = this.cdiContainer.getBeanManager();
        Map camels = manager.getBeans(CamelContext.class, new Annotation[]{Any.Literal.INSTANCE}).stream().map(bean -> (CamelContext)BeanManagerHelper.getReference((BeanManager)manager, CamelContext.class, (Bean)bean)).collect(Collectors.toMap(CamelContext::getName, Function.identity()));
        if (camels.size() > 1) {
            throw new IllegalArgumentException("Multiple CamelContext detected. This Main class only supports single CamelContext");
        }
        if (camels.size() == 1) {
            return (CamelContext)camels.values().iterator().next();
        }
        return null;
    }

    protected void doStart() throws Exception {
        SeContainerInitializer container = SeContainerInitializer.newInstance();
        this.cdiContainer = container.initialize();
        this.startContexts();
        super.doStart();
        this.initCamelContext();
        this.warnIfNoCamelFound();
    }

    protected void initCamelContext() throws Exception {
    }

    protected void startContexts() {
        if (!this.startContexts) {
            LOG.debug("Context are not automatically started");
            return;
        }
        try {
            RequestContextController requestContextController = (RequestContextController)this.cdiContainer.select(RequestContextController.class, new Annotation[0]).get();
            if (requestContextController.activate()) {
                LOG.debug("Request context started");
                this.stopHook = () -> ((RequestContextController)requestContextController).deactivate();
            } else {
                LOG.debug("Request context already started");
            }
        }
        catch (UnsatisfiedResolutionException e) {
            LOG.debug("Didn't start request scope", (Throwable)e);
        }
    }

    private void warnIfNoCamelFound() {
        BeanManager manager = this.cdiContainer.getBeanManager();
        Set contexts = manager.getBeans(CamelContext.class, new Annotation[]{Any.Literal.INSTANCE});
        if (contexts.isEmpty()) {
            LOG.warn("Camel CDI main has started with no Camel context!");
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.stopHook != null) {
            this.stopHook.run();
        }
        if (this.cdiContainer != null) {
            this.cdiContainer.close();
        }
    }

    static {
        System.setProperty("org.jboss.weld.se.shutdownHook", System.getProperty("org.jboss.weld.se.shutdownHook", String.valueOf(Boolean.FALSE)));
        LOG = LoggerFactory.getLogger(Main.class);
    }
}

