/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cdi;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiBeanRegistry
implements Registry {
    private static final Logger LOG = LoggerFactory.getLogger(CdiBeanRegistry.class);

    public Object lookup(String name) {
        ObjectHelper.notEmpty((String)name, (String)"name");
        LOG.trace("Looking up bean with name {}", (Object)name);
        return BeanProvider.getContextualReference((String)name, (boolean)true);
    }

    public <T> T lookup(String name, Class<T> type) {
        ObjectHelper.notEmpty((String)name, (String)"name");
        ObjectHelper.notNull(type, (String)"type");
        LOG.trace("Looking up bean with name {} of type {}", (Object)name, type);
        return (T)BeanProvider.getContextualReference((String)name, (boolean)true, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        ObjectHelper.notNull(type, (String)"type");
        LOG.trace("Lookups based of type {}", type);
        HashMap<String, Object> beans = new HashMap<String, Object>();
        Set definitions = BeanProvider.getBeanDefinitions(type, (boolean)true, (boolean)true);
        if (definitions == null) {
            return beans;
        }
        for (Bean bean : definitions) {
            if (bean.getName() == null) continue;
            beans.put(bean.getName(), BeanProvider.getContextualReference(type, (Bean)bean));
        }
        return beans;
    }

    public String toString() {
        return "CdiRegistry[" + System.identityHashCode(this) + "]";
    }
}

