/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

public final class CdiBeanManagerHelper {
    private CdiBeanManagerHelper() {
    }

    public static <T> T lookupBeanByType(BeanManager beanManager, Class<T> type) {
        CreationalContext creationalContext;
        Bean bean;
        Object result;
        Set beans = beanManager.getBeans(type, new Annotation[0]);
        if (!beans.isEmpty() && (result = beanManager.getReference(bean = beanManager.resolve(beans), type, creationalContext = beanManager.createCreationalContext((Contextual)bean))) != null) {
            return type.cast(result);
        }
        return null;
    }

    public static Object lookupBeanByName(BeanManager beanManager, String name) {
        return CdiBeanManagerHelper.lookupBeanByNameAndType(beanManager, name, Object.class);
    }

    public static <T> T lookupBeanByNameAndType(BeanManager beanManager, String name, Class<T> type) {
        CreationalContext creationalContext;
        Bean bean;
        Object result;
        Set beans = beanManager.getBeans(name);
        if (!beans.isEmpty() && (result = beanManager.getReference(bean = beanManager.resolve(beans), type, creationalContext = beanManager.createCreationalContext((Contextual)bean))) != null) {
            return type.cast(result);
        }
        return null;
    }
}

