/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.util.Collections;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.camel.cdi.CdiSpiHelper;
import org.apache.camel.cdi.SyntheticAnnotated;
import org.apache.camel.cdi.SyntheticBeanAttributes;

class SyntheticBean<T>
extends SyntheticBeanAttributes<T>
implements Bean<T>,
PassivationCapable {
    private final Class<?> type;
    private final InjectionTarget<T> target;
    private final Function<Bean<T>, String> toString;

    SyntheticBean(BeanManager manager, SyntheticAnnotated annotated, Class<?> type, InjectionTarget<T> target, Function<Bean<T>, String> toString) {
        super(manager, annotated);
        this.type = type;
        this.target = target;
        this.toString = toString;
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public T create(CreationalContext<T> creationalContext) {
        try {
            Object instance = this.target.produce(creationalContext);
            this.target.inject(instance, creationalContext);
            this.target.postConstruct(instance);
            return (T)instance;
        }
        catch (Exception cause) {
            throw new CreationException("Error while instantiating " + this, (Throwable)cause);
        }
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            this.target.preDestroy(instance);
            this.target.dispose(instance);
        }
        catch (Exception cause) {
            throw new InjectionException("Error while destroying " + this, (Throwable)cause);
        }
        finally {
            creationalContext.release();
        }
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public String toString() {
        return this.toString.apply(this);
    }

    public String getId() {
        return new StringJoiner("%").add("CAMEL-CDI").add(this.getClass().getSimpleName()).add(this.type.getName()).add(CdiSpiHelper.createBeanId(this)).toString();
    }
}

