/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.camel.CamelException;
import org.apache.camel.jta.JtaTransactionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionalJtaTransactionPolicy
extends JtaTransactionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalJtaTransactionPolicy.class);
    private static final String[] TRANSACTION_MANAGER_JNDI_NAMES = new String[]{"java:comp/TransactionManager", "java:appserver/TransactionManager", "java:pm/TransactionManager", "java:/TransactionManager"};
    protected TransactionManager transactionManager = this.lookupTransactionManager();

    protected void runWithTransaction(JtaTransactionPolicy.Runnable runnable, boolean isNew) throws Throwable {
        if (isNew) {
            this.begin();
        }
        try {
            runnable.run();
        }
        catch (Throwable e) {
            this.rollback(isNew);
            throw e;
        }
        if (isNew) {
            this.commit();
        }
    }

    private TransactionManager lookupTransactionManager() {
        for (String jndiName : TRANSACTION_MANAGER_JNDI_NAMES) {
            try {
                TransactionManager tm = (TransactionManager)InitialContext.doLookup(jndiName);
                LOG.debug("JTA TransactionManager found at JNDI location [{}]", (Object)jndiName);
                return tm;
            }
            catch (NamingException ex) {
                LOG.debug("No JTA TransactionManager found at JNDI location [{}]", (Object)jndiName, (Object)ex);
            }
        }
        LOG.warn("Could not find the transaction manager through any of following locations: {}", (Object)String.join((CharSequence)",", TRANSACTION_MANAGER_JNDI_NAMES));
        return null;
    }

    private void begin() throws Exception {
        this.transactionManager.begin();
    }

    private void commit() throws Exception {
        try {
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
            throw new CamelException("Unable to commit transaction", e);
        }
        catch (Error | Exception e) {
            this.rollback(true);
            throw e;
        }
    }

    protected void rollback(boolean isNew) throws Exception {
        try {
            if (isNew) {
                this.transactionManager.rollback();
            } else {
                this.transactionManager.setRollbackOnly();
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not rollback transaction!", e);
        }
    }

    protected Transaction suspendTransaction() throws Exception {
        return this.transactionManager.suspend();
    }

    protected void resumeTransaction(Transaction suspendedTransaction) {
        if (suspendedTransaction == null) {
            return;
        }
        try {
            this.transactionManager.resume(suspendedTransaction);
        }
        catch (Throwable e) {
            LOG.warn("Could not resume transaction!", e);
        }
    }

    protected boolean hasActiveTransaction() throws Exception {
        return this.transactionManager.getStatus() != 1 && this.transactionManager.getStatus() != 6;
    }
}

