/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Named;
import org.apache.camel.cdi.NamedLiteral;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.util.ObjectHelper;

@Vetoed
final class CdiEventNotifier
extends EventNotifierSupport {
    private final BeanManager manager;
    private final Annotation[] qualifiers;

    CdiEventNotifier(BeanManager manager, Collection<Annotation> qualifiers) {
        this.manager = manager;
        this.qualifiers = qualifiers.toArray(new Annotation[qualifiers.size()]);
    }

    public void notify(CamelEvent event) {
        String id = null;
        if (event instanceof CamelEvent.RouteEvent) {
            id = ((CamelEvent.RouteEvent)event).getRoute().getId();
        }
        if (ObjectHelper.isNotEmpty(id)) {
            ArrayList<Named> annotations = new ArrayList<Named>();
            Collections.addAll(annotations, this.qualifiers);
            annotations.add(NamedLiteral.of(id));
            this.manager.fireEvent((Object)event, annotations.toArray(new Annotation[0]));
        } else {
            this.manager.fireEvent((Object)event, this.qualifiers);
        }
    }

    public boolean isEnabled(CamelEvent event) {
        return true;
    }
}

