/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.configurator.BeanConfigurator;
import javax.inject.Named;
import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consume;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Converter;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.PropertyInject;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TypeConverter;
import org.apache.camel.cdi.AnnotatedMethodDelegate;
import org.apache.camel.cdi.AnnotatedTypeDelegate;
import org.apache.camel.cdi.ApplicationScopedLiteral;
import org.apache.camel.cdi.BeanDelegate;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.CamelBeanInjectionTarget;
import org.apache.camel.cdi.CdiCamelConfigurationEvent;
import org.apache.camel.cdi.CdiCamelContext;
import org.apache.camel.cdi.CdiCamelEnvironment;
import org.apache.camel.cdi.CdiCamelFactory;
import org.apache.camel.cdi.CdiEventEndpoint;
import org.apache.camel.cdi.CdiSpiHelper;
import org.apache.camel.cdi.CdiTypeConverterLoader;
import org.apache.camel.cdi.Excluded;
import org.apache.camel.cdi.ForwardingObserverMethod;
import org.apache.camel.cdi.ImportResource;
import org.apache.camel.cdi.Startup;
import org.apache.camel.cdi.SyntheticAnnotated;
import org.apache.camel.cdi.SyntheticBean;
import org.apache.camel.cdi.SyntheticInjectionTarget;
import org.apache.camel.cdi.Uri;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.model.Model;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteTemplateContainer;
import org.apache.camel.spi.CamelEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiCamelExtension
implements Extension {
    private final Logger logger = LoggerFactory.getLogger(CdiCamelExtension.class);
    private final CdiCamelEnvironment environment = new CdiCamelEnvironment();
    private final Set<Class<?>> converters = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<AnnotatedType<?>> camelBeans = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<AnnotatedType<?>> eagerBeans = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, CdiEventEndpoint<?>> cdiEventEndpoints = new ConcurrentHashMap();
    private final Set<Bean<?>> cdiBeans = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Annotation> contextQualifiers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Method, Bean<?>> producerBeans = new ConcurrentHashMap();
    private final Map<Method, Set<Annotation>> producerQualifiers = new ConcurrentHashMap<Method, Set<Annotation>>();
    private final Set<Annotation> eventQualifiers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<AnnotatedType<?>, ImportResource> resources = new ConcurrentHashMap();
    private final CdiCamelConfigurationEvent configuration = new CdiCamelConfigurationEvent();

    CdiEventEndpoint<?> getEventEndpoint(String uri) {
        return this.cdiEventEndpoints.get(uri);
    }

    Set<Annotation> getObserverEvents() {
        return this.eventQualifiers;
    }

    Set<Annotation> getContextQualifiers() {
        return this.contextQualifiers;
    }

    private void processAnnotatedType(@Observes ProcessAnnotatedType<?> pat) {
        if (pat.getAnnotatedType().isAnnotationPresent(Vetoed.class)) {
            pat.veto();
        }
        if (CdiSpiHelper.hasAnnotation(pat.getAnnotatedType(), Converter.class)) {
            this.converters.add(pat.getAnnotatedType().getJavaClass());
        }
        if (CdiSpiHelper.hasAnnotation(pat.getAnnotatedType(), BeanInject.class, Consume.class, EndpointInject.class, Produce.class, PropertyInject.class)) {
            this.camelBeans.add(pat.getAnnotatedType());
        }
        if (CdiSpiHelper.hasAnnotation(pat.getAnnotatedType(), Consume.class)) {
            this.eagerBeans.add(pat.getAnnotatedType());
        }
        if (CdiSpiHelper.hasAnnotation(pat.getAnnotatedType(), ImportResource.class)) {
            this.resources.put(pat.getAnnotatedType(), (ImportResource)pat.getAnnotatedType().getAnnotation(ImportResource.class));
        }
    }

    private <T extends CamelContext> void camelContextBeans(@Observes ProcessInjectionTarget<T> pit, BeanManager manager) {
        pit.setInjectionTarget(this.environment.camelContextInjectionTarget(pit.getInjectionTarget(), (Annotated)pit.getAnnotatedType(), manager, this));
    }

    private <T extends CamelContext> void camelContextProducers(@Observes ProcessProducer<?, T> pp, BeanManager manager) {
        pp.setProducer(this.environment.camelContextProducer(pp.getProducer(), (Annotated)pp.getAnnotatedMember(), manager, this));
    }

    private <T> void camelBeansPostProcessor(@Observes ProcessInjectionTarget<T> pit, BeanManager manager) {
        if (this.camelBeans.contains(pit.getAnnotatedType())) {
            pit.setInjectionTarget(new CamelBeanInjectionTarget(pit.getInjectionTarget(), manager));
        }
    }

    private <T extends CamelContextAware> void camelContextAware(@Observes ProcessInjectionTarget<T> pit, BeanManager manager) {
        pit.setInjectionTarget(new CamelBeanInjectionTarget(pit.getInjectionTarget(), manager));
    }

    private <T extends Endpoint> void endpointBeans(@Observes ProcessProducerMethod<T, CdiCamelFactory> ppm) {
        this.producerBeans.put(ppm.getAnnotatedProducerMethod().getJavaMember(), ppm.getBean());
    }

    private void consumerTemplateBeans(@Observes ProcessProducerMethod<ConsumerTemplate, CdiCamelFactory> ppm) {
        this.producerBeans.put(ppm.getAnnotatedProducerMethod().getJavaMember(), ppm.getBean());
    }

    private void producerTemplateBeans(@Observes ProcessProducerMethod<ProducerTemplate, CdiCamelFactory> ppm) {
        this.producerBeans.put(ppm.getAnnotatedProducerMethod().getJavaMember(), ppm.getBean());
    }

    private void fluentProducerTemplateBeans(@Observes ProcessProducerMethod<FluentProducerTemplate, CdiCamelFactory> ppm) {
        this.producerBeans.put(ppm.getAnnotatedProducerMethod().getJavaMember(), ppm.getBean());
    }

    private void camelFactoryProducers(@Observes ProcessAnnotatedType<CdiCamelFactory> pat, BeanManager manager) {
        pat.setAnnotatedType(new AnnotatedTypeDelegate(pat.getAnnotatedType(), pat.getAnnotatedType().getMethods().stream().filter(am -> am.isAnnotationPresent(Produces.class)).filter(am -> am.getTypeClosure().stream().noneMatch(Predicate.isEqual(TypeConverter.class))).peek(am -> this.producerQualifiers.put(am.getJavaMember(), CdiSpiHelper.getQualifiers((Annotated)am, manager))).map(am -> new AnnotatedMethodDelegate(am, (Set<Annotation>)am.getAnnotations().stream().filter(annotation -> !manager.isQualifier(annotation.annotationType())).collect(Collectors.collectingAndThen(Collectors.toSet(), annotations -> {
            annotations.add(Excluded.EXCLUDED);
            return annotations;
        })))).collect(Collectors.toSet())));
    }

    private <T extends CamelEvent> void camelEventNotifiers(@Observes ProcessObserverMethod<T, ?> pom) {
        Type type = pom.getObserverMethod().getObservedType();
        if (type instanceof Class && CamelEvent.class.isAssignableFrom((Class)Class.class.cast(type))) {
            Set qualifiers = pom.getObserverMethod().getObservedQualifiers();
            if (qualifiers.isEmpty()) {
                this.eventQualifiers.add((Annotation)Any.Literal.INSTANCE);
            } else if (qualifiers.size() == 1 && qualifiers.stream().anyMatch(CdiSpiHelper.isAnnotationType(Named.class))) {
                this.eventQualifiers.add((Annotation)Default.Literal.INSTANCE);
            } else {
                this.eventQualifiers.addAll(qualifiers);
            }
        }
    }

    private void beans(@Observes ProcessProducerField<?, ?> pb) {
        this.cdiBeans.add(pb.getBean());
    }

    private void beans(@Observes ProcessProducerMethod<?, ?> pb) {
        this.cdiBeans.add(pb.getBean());
    }

    private void beans(@Observes ProcessBean<?> pb, BeanManager manager) {
        this.cdiBeans.add(pb.getBean());
        pb.getBean().getInjectionPoints().stream().filter(ip -> CdiEventEndpoint.class.equals(CdiSpiHelper.getRawType(ip.getType()))).forEach(ip -> {
            Class<Object> type = ip.getType() instanceof ParameterizedType ? ((ParameterizedType)ip.getType()).getActualTypeArguments()[0] : Object.class;
            String uri = CdiEventEndpoint.eventEndpointUri(type, ip.getQualifiers());
            this.cdiEventEndpoints.put(uri, new CdiEventEndpoint(uri, (Type)((Object)type), ip.getQualifiers(), manager));
        });
    }

    private void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager manager) {
        Bean context;
        HashSet extraBeans = new HashSet();
        Stream.concat(this.cdiBeans.stream(), extraBeans.stream()).filter(CdiSpiHelper.hasType(CamelContext.class)).map(BeanAttributes::getQualifiers).forEach(this.contextQualifiers::addAll);
        Set<Bean<?>> allBeans = Stream.concat(this.cdiBeans.stream(), extraBeans.stream()).collect(Collectors.toSet());
        Set contexts = allBeans.stream().filter(CdiSpiHelper.hasType(CamelContext.class)).collect(Collectors.toSet());
        if (contexts.isEmpty() && this.shouldDeployDefaultCamelContext(allBeans)) {
            extraBeans.add(this.camelContextBean(manager, null, new Annotation[]{Any.Literal.INSTANCE, Default.Literal.INSTANCE, ApplicationScopedLiteral.APPLICATION_SCOPED}));
        } else if (contexts.size() == 1 && !(context = (Bean)contexts.iterator().next()).getQualifiers().contains(Default.Literal.INSTANCE) && context instanceof SyntheticBean) {
            ((SyntheticBean)context).addQualifier(Default.Literal.INSTANCE);
        }
        extraBeans.forEach(arg_0 -> ((AfterBeanDiscovery)abd).addBean(arg_0));
        Set endpointQualifiers = this.cdiEventEndpoints.values().stream().map(CdiEventEndpoint::getQualifiers).flatMap(Collection::stream).collect(Collectors.toSet());
        Set<Annotation> templateQualifiers = this.contextQualifiers.stream().filter(CdiSpiHelper.isAnnotationType(Default.class).or(CdiSpiHelper.isAnnotationType(Named.class)).negate()).collect(Collectors.toSet());
        this.producerBeans.entrySet().stream().map(producer -> new BeanDelegate((Bean)producer.getValue(), this.producerQualifiers.get(producer.getKey()), CdiEventEndpoint.class.equals(((Method)producer.getKey()).getReturnType()) ? endpointQualifiers : templateQualifiers)).forEach(arg_0 -> ((AfterBeanDiscovery)abd).addBean(arg_0));
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null && (loader = this.getClass().getClassLoader()) == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            Class<Endpoint> endpointType = loader.loadClass("org.apache.camel.component.mock.MockEndpoint").asSubclass(Endpoint.class);
            this.addCamelMockBeans(abd, endpointType, templateQualifiers);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
        }
        this.cdiEventEndpoints.values().stream().map(ForwardingObserverMethod::new).forEach(arg_0 -> ((AfterBeanDiscovery)abd).addObserverMethod(arg_0));
    }

    private <T extends Endpoint> void addCamelMockBeans(AfterBeanDiscovery afterBeanDiscovery, Class<T> type, Set<Annotation> templateQualifiers) {
        this.addBean(afterBeanDiscovery, type).id(this.getClass().getName() + "#mockEndpoint").qualifiers(new Annotation[]{Default.Literal.INSTANCE, Uri.Literal.of(""), Any.Literal.INSTANCE}).addQualifiers(templateQualifiers).produceWith(instance -> this.newEndpoint(type, (Instance<Object>)instance, ip -> CdiCamelFactory.getQualifierByType(ip, Uri.class).map(Uri::value).orElseGet(() -> "mock:" + ip.getMember().getName())));
    }

    private <T extends Endpoint> BeanConfigurator<T> addBean(AfterBeanDiscovery afterBeanDiscovery, Class<T> type) {
        return afterBeanDiscovery.addBean().scope(Dependent.class).beanClass(type).types(new Type[]{type, Object.class});
    }

    private <T extends Endpoint> T newEndpoint(Class<T> type, Instance<Object> instance, Function<InjectionPoint, String> uriFactory) {
        InjectionPoint ip = (InjectionPoint)instance.select(InjectionPoint.class, new Annotation[0]).get();
        Instance contexts = instance.select(CamelContext.class, new Annotation[]{Any.Literal.INSTANCE});
        return this.lookupEndpoint(type, ip, (Instance<CamelContext>)contexts, uriFactory.apply(ip));
    }

    private <T extends Endpoint> T lookupEndpoint(Class<T> type, InjectionPoint ip, Instance<CamelContext> contexts, String uri) {
        try {
            return (T)CdiCamelFactory.selectContext(ip, contexts, this).getEndpoint(uri, type);
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting mock endpoint into " + ip, (Throwable)cause);
        }
    }

    private boolean shouldDeployDefaultCamelContext(Set<Bean<?>> beans) {
        return beans.stream().filter(bean -> !this.getClass().getPackage().equals(bean.getBeanClass().getPackage())).filter(CdiSpiHelper.hasType(CamelContextAware.class).or(CdiSpiHelper.hasType(Component.class)).or(CdiSpiHelper.hasType(RouteContainer.class).or(CdiSpiHelper.hasType(RoutesBuilder.class)))).map(BeanAttributes::getQualifiers).flatMap(Collection::stream).anyMatch(Predicate.isEqual(Default.Literal.INSTANCE)) || Stream.concat(this.camelBeans.stream().map(AnnotatedType::getFields), this.camelBeans.stream().map(AnnotatedType::getMethods)).flatMap(Collection::stream).map(Annotated::getAnnotations).flatMap(Collection::stream).anyMatch(CdiSpiHelper.isAnnotationType(Consume.class).or(CdiSpiHelper.isAnnotationType(BeanInject.class)).or(CdiSpiHelper.isAnnotationType(EndpointInject.class)).or(CdiSpiHelper.isAnnotationType(Produce.class)).or(CdiSpiHelper.isAnnotationType(PropertyInject.class))) || beans.stream().filter(bean -> !this.getClass().getPackage().equals(bean.getBeanClass().getPackage())).map(Bean::getInjectionPoints).flatMap(Collection::stream).filter(ip -> CdiSpiHelper.getRawType(ip.getType()).getName().startsWith("org.apache.camel")).map(InjectionPoint::getQualifiers).flatMap(Collection::stream).anyMatch(CdiSpiHelper.isAnnotationType(Uri.class).or(Predicate.isEqual(Default.Literal.INSTANCE)));
    }

    private SyntheticBean<?> camelContextBean(BeanManager manager, Class<?> beanClass, Annotation ... qualifiers) {
        SyntheticAnnotated annotated = new SyntheticAnnotated(CdiCamelContext.class, (Set<Type>)manager.createAnnotatedType(CdiCamelContext.class).getTypeClosure(), beanClass, qualifiers);
        return new SyntheticBean<CdiCamelContext>(manager, annotated, CdiCamelContext.class, this.environment.camelContextInjectionTarget(new SyntheticInjectionTarget<CdiCamelContext>(CdiCamelContext::new), annotated, manager, this), bean -> "CdiCamelContext bean with qualifiers " + bean.getQualifiers());
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation adv, BeanManager manager) {
        manager.getEvent().fire((Object)this.configuration);
        this.configuration.unmodifiable();
        ArrayList<CamelContext> contexts = new ArrayList<CamelContext>();
        for (Bean bean2 : manager.getBeans(CamelContext.class, new Annotation[]{Any.Literal.INSTANCE})) {
            contexts.add(BeanManagerHelper.getReference(manager, CamelContext.class, bean2));
        }
        for (CamelContext camelContext : contexts) {
            CdiTypeConverterLoader loader = new CdiTypeConverterLoader();
            for (Class<?> converter : this.converters) {
                loader.loadConverterMethods(camelContext.getTypeConverterRegistry(), converter);
            }
        }
        if (this.configuration.autoConfigureRoutes()) {
            boolean deploymentException = false;
            HashSet hashSet = new HashSet(manager.getBeans(RoutesBuilder.class, new Annotation[]{Any.Literal.INSTANCE}));
            hashSet.addAll(manager.getBeans(RouteContainer.class, new Annotation[]{Any.Literal.INSTANCE}));
            for (Bean context : manager.getBeans(CamelContext.class, new Annotation[]{Any.Literal.INSTANCE})) {
                ArrayList<BooleanSupplier> postAdditionActions = new ArrayList<BooleanSupplier>();
                for (Bean route : hashSet) {
                    HashSet qualifiers = new HashSet(context.getQualifiers());
                    qualifiers.retainAll(route.getQualifiers());
                    if (qualifiers.size() <= 1) continue;
                    deploymentException |= !this.addRouteToContext(route, context, manager, adv, postAdditionActions);
                }
                for (BooleanSupplier action : postAdditionActions) {
                    deploymentException |= !action.getAsBoolean();
                }
            }
            if (deploymentException) {
                return;
            }
        }
        this.eagerBeans.forEach(type -> BeanManagerHelper.getReferencesByType(manager, type.getJavaClass(), new Annotation[]{Any.Literal.INSTANCE}).toString());
        manager.getBeans(Object.class, new Annotation[]{Any.Literal.INSTANCE, Startup.Literal.STARTUP}).forEach(bean -> BeanManagerHelper.getReference(manager, bean.getBeanClass(), bean).toString());
        if (this.configuration.autoStartContexts()) {
            for (CamelContext camelContext : contexts) {
                if (ServiceStatus.Started.equals((Object)camelContext.getStatus())) continue;
                this.logger.info("Camel CDI is starting Camel context [{}]", (Object)camelContext.getName());
                try {
                    camelContext.start();
                }
                catch (Exception exception) {
                    adv.addDeploymentProblem((Throwable)exception);
                }
            }
        }
        Stream.of(this.converters, this.camelBeans, this.eagerBeans, this.cdiBeans).forEach(Set::clear);
        Stream.of(this.producerBeans, this.producerQualifiers).forEach(Map::clear);
    }

    private BooleanSupplier templatedRoutesAddition(Bean<?> routeBean, AfterDeploymentValidation adv, CamelContext context, RoutesBuilder builder) {
        return () -> {
            try {
                context.addTemplatedRoutes(builder);
                return true;
            }
            catch (Exception cause) {
                adv.addDeploymentProblem((Throwable)new InjectionException("Error adding templated routes of type [" + routeBean.getBeanClass().getName() + "] to Camel context [" + context.getName() + "]", (Throwable)cause));
                return false;
            }
        };
    }

    private boolean addRouteToContext(Bean<?> routeBean, Bean<?> contextBean, BeanManager manager, AfterDeploymentValidation adv, List<BooleanSupplier> postAdditionActions) {
        try {
            CamelContext context = BeanManagerHelper.getReference(manager, CamelContext.class, contextBean);
            try {
                Object route = BeanManagerHelper.getReference(manager, Object.class, routeBean);
                if (route instanceof RoutesBuilder) {
                    RoutesBuilder builder = (RoutesBuilder)route;
                    context.addRoutes(builder);
                    postAdditionActions.add(this.templatedRoutesAddition(routeBean, adv, context, builder));
                } else if (route instanceof RouteContainer) {
                    ((Model)context.getExtension(Model.class)).addRouteDefinitions((Collection)((RouteContainer)route).getRoutes());
                } else if (route instanceof RouteTemplateContainer) {
                    ((Model)context.getExtension(Model.class)).addRouteTemplateDefinitions((Collection)((RouteTemplateContainer)route).getRouteTemplates());
                } else {
                    throw new IllegalArgumentException("Invalid routes type [" + routeBean.getBeanClass().getName() + "], must be either of type RoutesBuilder or RouteContainer!");
                }
                return true;
            }
            catch (Exception cause) {
                adv.addDeploymentProblem((Throwable)new InjectionException("Error adding routes of type [" + routeBean.getBeanClass().getName() + "] to Camel context [" + context.getName() + "]", (Throwable)cause));
            }
        }
        catch (Exception exception) {
            adv.addDeploymentProblem((Throwable)exception);
        }
        return false;
    }
}

