/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.transaction;

import javax.annotation.Resource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.camel.CamelException;
import org.apache.camel.jta.JtaTransactionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionalJtaTransactionPolicy
extends JtaTransactionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalJtaTransactionPolicy.class);
    @Resource(lookup="java:/TransactionManager")
    protected TransactionManager transactionManager;

    protected void runWithTransaction(JtaTransactionPolicy.Runnable runnable, boolean isNew) throws Throwable {
        if (isNew) {
            this.begin();
        }
        try {
            runnable.run();
        }
        catch (Throwable e) {
            this.rollback(isNew);
            throw e;
        }
        if (isNew) {
            this.commit();
        }
    }

    private void begin() throws Exception {
        this.transactionManager.begin();
    }

    private void commit() throws Exception {
        try {
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
            throw new CamelException("Unable to commit transaction", e);
        }
        catch (Error | Exception e) {
            this.rollback(true);
            throw e;
        }
    }

    protected void rollback(boolean isNew) throws Exception {
        try {
            if (isNew) {
                this.transactionManager.rollback();
            } else {
                this.transactionManager.setRollbackOnly();
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not rollback transaction!", e);
        }
    }

    protected Transaction suspendTransaction() throws Exception {
        return this.transactionManager.suspend();
    }

    protected void resumeTransaction(Transaction suspendedTransaction) {
        if (suspendedTransaction == null) {
            return;
        }
        try {
            this.transactionManager.resume(suspendedTransaction);
        }
        catch (Throwable e) {
            LOG.warn("Could not resume transaction!", e);
        }
    }

    protected boolean hasActiveTransaction() throws Exception {
        return this.transactionManager.getStatus() != 1 && this.transactionManager.getStatus() != 6;
    }
}

