/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.chatscript;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.chatscript.ChatScriptEndpoint;
import org.apache.camel.component.chatscript.ChatScriptMessage;
import org.apache.camel.support.DefaultProducer;

public class ChatScriptProducer
extends DefaultProducer {
    private ChatScriptEndpoint endpoint;
    private ObjectMapper mapper = new ObjectMapper();

    public ChatScriptProducer(ChatScriptEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        if (endpoint.isResetChat()) {
            this.endpoint.getBot().reset();
        }
    }

    public void process(Exchange exchange) throws Exception {
        Object body = exchange.getIn().getBody();
        ChatScriptMessage inputMessage = new ChatScriptMessage();
        inputMessage = !(body instanceof ChatScriptMessage) ? this.buildMessage(body) : (ChatScriptMessage)body;
        inputMessage.setBotName(this.endpoint.getBotName());
        String response = this.endpoint.getBot().sendChat(inputMessage);
        inputMessage.setReply(response);
        exchange.getOut().setBody((Object)inputMessage);
    }

    private ChatScriptMessage buildMessage(Object body) throws Exception {
        if (body instanceof String) {
            return this.createMessage(String.valueOf(body));
        }
        return null;
    }

    private ChatScriptMessage createMessage(String message) throws Exception {
        ChatScriptMessage ret = null;
        try {
            ret = (ChatScriptMessage)this.mapper.readValue(message, ChatScriptMessage.class);
        }
        catch (Exception e) {
            throw new Exception("Unable to parse the input message. Error Message" + e.getMessage(), e);
        }
        return ret;
    }
}

