/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cm;

import org.apache.camel.component.cm.CMUtils;

public class CMMessage {
    private String idAsString;
    private String phoneNumber;
    private String message;
    private String sender;
    private boolean unicode;
    private int multipart = 1;

    public CMMessage(String phoneNumber, String message) {
        this.message = message;
        this.phoneNumber = phoneNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getIdAsString() {
        return this.idAsString;
    }

    public void setIdAsString(String idAsString) {
        this.idAsString = idAsString;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public void setUnicode(boolean unicode) {
        this.unicode = unicode;
    }

    public boolean isMultipart() {
        return this.multipart > 1;
    }

    public void setUnicodeAndMultipart(int defaultMaxNumberOfParts) {
        String msg = this.getMessage();
        if (CMUtils.isGsm0338Encodeable(msg)) {
            if (msg.length() > 160) {
                int parts = msg.length() / 153;
                if (msg.length() % 153 != 0) {
                    ++parts;
                }
                this.setMultiparts(parts > defaultMaxNumberOfParts ? defaultMaxNumberOfParts : parts);
            } else {
                this.setMultiparts(1);
            }
        } else {
            this.setUnicode(true);
            if (msg.length() > 70) {
                int parts = msg.length() / 67;
                if (msg.length() % 67 != 0) {
                    ++parts;
                }
                this.setMultiparts(parts > defaultMaxNumberOfParts ? defaultMaxNumberOfParts : parts);
            } else {
                this.setMultiparts(1);
            }
        }
    }

    public void setMultiparts(int multipart) {
        this.multipart = multipart;
    }

    public int getMultiparts() {
        return this.multipart;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(" {phoneNumber: " + this.phoneNumber + ", message: " + this.message + ", sender=" + this.sender + ", unicode: " + this.unicode + ", multipart: " + this.multipart);
        if (this.idAsString != null && !this.idAsString.isEmpty()) {
            sb.append(", idAsString=").append(this.idAsString);
        }
        sb.append(" }");
        return sb.toString();
    }
}

