/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import java.io.InputStream;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cmis.CMISEndpoint;
import org.apache.camel.component.cmis.CMISSessionFacade;
import org.apache.camel.component.cmis.CMISSessionFacadeFactory;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMISConsumer
extends ScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CMISConsumer.class);
    private final CMISSessionFacadeFactory sessionFacadeFactory;
    private CMISSessionFacade sessionFacade;

    public CMISConsumer(CMISEndpoint cmisEndpoint, Processor processor, CMISSessionFacadeFactory sessionFacadeFactory) {
        super((Endpoint)cmisEndpoint, processor);
        this.sessionFacadeFactory = sessionFacadeFactory;
        this.sessionFacade = null;
    }

    public CMISEndpoint getEndpoint() {
        return (CMISEndpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        return this.getSessionFacade().poll(this);
    }

    public OperationContext createOperationContext() throws Exception {
        return this.getSessionFacade().createOperationContext();
    }

    int sendExchangeWithPropsAndBody(Map<String, Object> properties, InputStream inputStream) throws Exception {
        Exchange exchange = this.createExchange(true);
        exchange.getIn().setHeaders(properties);
        exchange.getIn().setBody((Object)inputStream);
        LOG.debug("Polling node: {}", properties.get("cmis:name"));
        this.getProcessor().process(exchange);
        return 1;
    }

    private CMISSessionFacade getSessionFacade() throws Exception {
        if (this.sessionFacade == null) {
            this.sessionFacade = this.sessionFacadeFactory.create(this.getEndpoint());
            this.sessionFacade.initSession();
        }
        return this.sessionFacade;
    }
}

