/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.coap.CoAPEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.config.NetworkConfig;

public class CoAPComponent
extends UriEndpointComponent
implements RestConsumerFactory {
    final Map<Integer, CoapServer> servers = new ConcurrentHashMap<Integer, CoapServer>();
    CoapServer defaultServer;

    public CoAPComponent() {
        super(CoAPEndpoint.class);
    }

    public CoAPComponent(CamelContext context) {
        super(context, CoAPEndpoint.class);
    }

    public synchronized CoapServer getServer(int port) {
        CoapServer server = this.servers.get(port);
        if (server == null && port == -1) {
            server = this.defaultServer;
        }
        if (server == null && port == -1) {
            server = this.servers.get(5684);
        }
        if (server == null) {
            NetworkConfig config = new NetworkConfig();
            server = new CoapServer(config, new int[]{port});
            this.servers.put(port, server);
            if (this.isStarted()) {
                server.start();
            }
        }
        return server;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CoAPEndpoint endpoint = new CoAPEndpoint(uri, this);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String host;
        RestConfiguration config = configuration;
        if (config == null) {
            config = this.getCamelContext().getRestConfiguration("coap", true);
        }
        if (ObjectHelper.isEmpty((Object)(host = config.getHost()))) {
            if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                host = "0.0.0.0";
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        HashMap map = new HashMap();
        if (config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        boolean cors = config.isEnableCORS();
        String query = URISupport.createQueryString(map);
        String url = (config.getScheme() == null ? "coap" : config.getScheme()) + "://" + host;
        if (config.getPort() != -1) {
            url = url + ":" + config.getPort();
        }
        String restrict = verb.toUpperCase(Locale.US);
        if (cors) {
            restrict = restrict + ",OPTIONS";
        }
        if (uriTemplate == null) {
            uriTemplate = "";
        }
        url = url + basePath + uriTemplate + "?coapMethod=" + restrict;
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        CoAPEndpoint endpoint = (CoAPEndpoint)camelContext.getEndpoint(url, CoAPEndpoint.class);
        this.setProperties((Object)endpoint, parameters);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        RestConfiguration config = this.getCamelContext().getRestConfiguration("coap", true);
        if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
            this.setProperties((Object)this, config.getComponentProperties());
        }
        this.defaultServer = this.getServer(config.getPort());
        for (CoapServer s : this.servers.values()) {
            s.start();
        }
    }

    protected void doStop() throws Exception {
        for (CoapServer s : this.servers.values()) {
            s.stop();
        }
        super.doStop();
    }
}

