/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.coap.CamelCoapResource;
import org.apache.camel.coap.CoAPComponent;
import org.apache.camel.coap.CoAPConstants;
import org.apache.camel.coap.CoAPConsumer;
import org.apache.camel.coap.CoAPHelper;
import org.apache.camel.coap.CoAPNotifier;
import org.apache.camel.coap.CoAPObserver;
import org.apache.camel.coap.CoAPProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.jsse.ClientAuthentication;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.tcp.netty.TcpClientConnector;
import org.eclipse.californium.elements.tcp.netty.TlsClientConnector;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustedRpkStore;

@UriEndpoint(firstVersion="2.16.0", scheme="coap,coaps,coap+tcp,coaps+tcp", title="CoAP", syntax="coap:uri", category={Category.IOT}, headersClass=CoAPConstants.class)
public class CoAPEndpoint
extends DefaultEndpoint {
    @UriPath
    private URI uri;
    @UriParam(label="consumer", enums="DELETE,GET,POST,PUT")
    private String coapMethodRestrict;
    @UriParam(label="security", secret=true)
    private PrivateKey privateKey;
    @UriParam(label="security")
    private PublicKey publicKey;
    @UriParam(label="security")
    private TrustedRpkStore trustedRpkStore;
    @UriParam(label="security")
    private PskStore pskStore;
    @UriParam(label="security")
    private String cipherSuites;
    private transient String[] configuredCipherSuites;
    @UriParam(label="security")
    private String clientAuthentication;
    @UriParam(label="security", enums="NONE,WANT,REQUIRE")
    private String alias;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="security", defaultValue="true")
    private boolean recommendedCipherSuitesOnly = true;
    @UriParam(label="consumer", defaultValue="false")
    private boolean observe;
    @UriParam(label="consumer", defaultValue="false")
    private boolean observable;
    @UriParam(label="producer", defaultValue="false")
    private boolean notify;
    private CoAPComponent component;

    public CoAPEndpoint(String uri, CoAPComponent component) {
        super(uri, (Component)component);
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException use) {
            this.uri = null;
        }
        this.component = component;
    }

    public void setCoapMethodRestrict(String coapMethodRestrict) {
        this.coapMethodRestrict = coapMethodRestrict;
    }

    public String getCoapMethodRestrict() {
        return this.coapMethodRestrict;
    }

    public Producer createProducer() throws Exception {
        if (this.isNotify()) {
            return new CoAPNotifier(this);
        }
        return new CoAPProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DefaultConsumer consumer = this.isObserve() ? new CoAPObserver(this, processor) : new CoAPConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void setUri(URI u) {
        this.uri = u;
    }

    public URI getUri() {
        return this.uri;
    }

    public CamelCoapResource getCamelCoapResource(String path) throws IOException, GeneralSecurityException {
        Resource current;
        Iterator<String> pathSegments = CoAPHelper.getPathSegmentsFromPath(path).iterator();
        if (!pathSegments.hasNext()) {
            return null;
        }
        for (current = this.getCoapServer().getRoot(); pathSegments.hasNext() && current != null; current = current.getChild(pathSegments.next())) {
        }
        return (CamelCoapResource)current;
    }

    public List<String> getPathSegmentsFromURI() {
        return CoAPHelper.getPathSegmentsFromPath(this.getUri().getPath());
    }

    public CoapServer getCoapServer() throws IOException, GeneralSecurityException {
        return this.component.getServer(this.getUri().getPort(), this);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isObserve() {
        return this.observe;
    }

    public void setObserve(boolean observe) {
        this.observe = observe;
    }

    public boolean isObservable() {
        return this.observable;
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public TrustedRpkStore getTrustedRpkStore() {
        return this.trustedRpkStore;
    }

    public void setTrustedRpkStore(TrustedRpkStore trustedRpkStore) {
        this.trustedRpkStore = trustedRpkStore;
    }

    public PskStore getPskStore() {
        return this.pskStore;
    }

    public void setPskStore(PskStore pskStore) {
        this.pskStore = pskStore;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public String getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String cipherSuites) {
        this.cipherSuites = cipherSuites;
        if (cipherSuites != null) {
            this.configuredCipherSuites = cipherSuites.split(",");
        }
    }

    private String[] getConfiguredCipherSuites() {
        if (this.configuredCipherSuites != null) {
            return this.configuredCipherSuites;
        }
        if (this.sslContextParameters != null && this.sslContextParameters.getCipherSuites() != null) {
            return this.sslContextParameters.getCipherSuites().getCipherSuite().toArray(new String[0]);
        }
        return null;
    }

    public String getClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(String clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    public boolean isRecommendedCipherSuitesOnly() {
        return this.recommendedCipherSuitesOnly;
    }

    public void setRecommendedCipherSuitesOnly(boolean recommendedCipherSuitesOnly) {
        this.recommendedCipherSuitesOnly = recommendedCipherSuitesOnly;
    }

    public boolean isClientAuthenticationRequired() {
        String clientAuth = this.clientAuthentication;
        if (clientAuth == null && this.sslContextParameters != null && this.sslContextParameters.getServerParameters() != null) {
            clientAuth = this.sslContextParameters.getServerParameters().getClientAuthentication();
        }
        return clientAuth != null && ClientAuthentication.valueOf((String)clientAuth) == ClientAuthentication.REQUIRE;
    }

    public boolean isClientAuthenticationWanted() {
        String clientAuth = this.clientAuthentication;
        if (clientAuth == null && this.sslContextParameters != null && this.sslContextParameters.getServerParameters() != null) {
            clientAuth = this.sslContextParameters.getServerParameters().getClientAuthentication();
        }
        return clientAuth != null && ClientAuthentication.valueOf((String)clientAuth) == ClientAuthentication.WANT;
    }

    private Certificate[] getTrustedCerts() throws GeneralSecurityException, IOException {
        if (this.sslContextParameters != null && this.sslContextParameters.getTrustManagers() != null) {
            KeyStore trustStore = this.sslContextParameters.getTrustManagers().getKeyStore().createKeyStore();
            Enumeration<String> aliases = trustStore.aliases();
            ArrayList<X509Certificate> trustCerts = new ArrayList<X509Certificate>();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)trustStore.getCertificate(alias);
                if (cert == null) continue;
                trustCerts.add(cert);
            }
            return trustCerts.toArray(new Certificate[0]);
        }
        return new Certificate[0];
    }

    public static boolean enableDTLS(URI uri) {
        return "coaps".equals(uri.getScheme());
    }

    public static boolean enableTCP(URI uri) {
        return uri.getScheme().endsWith("+tcp");
    }

    public DTLSConnector createDTLSConnector(InetSocketAddress address, boolean client) throws IOException {
        DtlsConnectorConfig.Builder builder = new DtlsConnectorConfig.Builder();
        if (client) {
            if (this.trustedRpkStore == null && this.sslContextParameters == null && this.pskStore == null) {
                throw new IllegalStateException("Either a trustedRpkStore, sslContextParameters or pskStore object must be configured for a TLS client");
            }
            builder.setRecommendedCipherSuitesOnly(this.isRecommendedCipherSuitesOnly());
            builder.setClientOnly();
        } else {
            if (this.privateKey == null && this.sslContextParameters == null && this.pskStore == null) {
                throw new IllegalStateException("Either a privateKey, sslContextParameters or pskStore object must be configured for a TLS service");
            }
            if (this.privateKey != null && this.publicKey == null) {
                throw new IllegalStateException("A public key must be configured to use a Raw Public Key with TLS");
            }
            if ((this.isClientAuthenticationRequired() || this.isClientAuthenticationWanted()) && (this.sslContextParameters == null || this.sslContextParameters.getTrustManagers() == null) && this.publicKey == null) {
                throw new IllegalStateException("A truststore must be configured to support TLS client authentication");
            }
            builder.setAddress(address);
            builder.setClientAuthenticationRequired(this.isClientAuthenticationRequired());
            builder.setClientAuthenticationWanted(this.isClientAuthenticationWanted());
            builder.setRecommendedCipherSuitesOnly(this.isRecommendedCipherSuitesOnly());
        }
        try {
            Certificate[] certs;
            if (this.sslContextParameters != null && this.sslContextParameters.getKeyManagers() != null) {
                KeyManagersParameters keyManagers = this.sslContextParameters.getKeyManagers();
                KeyStore keyStore = keyManagers.getKeyStore().createKeyStore();
                String alias = this.getAlias();
                if (alias == null) {
                    Enumeration<String> aliases = keyStore.aliases();
                    while (aliases.hasMoreElements()) {
                        String ksAlias = aliases.nextElement();
                        if (!keyStore.isKeyEntry(ksAlias)) continue;
                        alias = ksAlias;
                        break;
                    }
                }
                if (alias == null) {
                    throw new IllegalStateException("The sslContextParameters keystore must contain a key entry");
                }
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, keyManagers.getKeyPassword().toCharArray());
                builder.setIdentity(privateKey, keyStore.getCertificateChain(alias), new CertificateType[0]);
            } else if (this.privateKey != null) {
                builder.setIdentity(this.privateKey, this.publicKey);
            }
            if (this.pskStore != null) {
                builder.setPskStore(this.pskStore);
            }
            if ((certs = this.getTrustedCerts()).length > 0) {
                builder.setTrustStore(certs);
            }
            if (this.trustedRpkStore != null) {
                builder.setTrustCertificateTypes(new CertificateType[]{CertificateType.RAW_PUBLIC_KEY});
                builder.setRpkTrustStore(this.trustedRpkStore);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Error in configuring TLS", e);
        }
        if (this.getConfiguredCipherSuites() != null) {
            builder.setSupportedCipherSuites(this.getConfiguredCipherSuites());
        }
        return new DTLSConnector(builder.build());
    }

    public CoapClient createCoapClient(URI uri) throws IOException, GeneralSecurityException {
        CoapClient client = new CoapClient(uri);
        if (CoAPEndpoint.enableDTLS(uri)) {
            DTLSConnector connector = this.createDTLSConnector(null, true);
            CoapEndpoint.Builder coapBuilder = new CoapEndpoint.Builder();
            coapBuilder.setConnector((Connector)connector);
            client.setEndpoint((Endpoint)coapBuilder.build());
        } else if (CoAPEndpoint.enableTCP(this.getUri())) {
            NetworkConfig config = NetworkConfig.createStandardWithoutFile();
            int tcpThreads = config.getInt("TCP_WORKER_THREADS");
            int tcpConnectTimeout = config.getInt("TCP_CONNECT_TIMEOUT");
            int tcpIdleTimeout = config.getInt("TCP_CONNECTION_IDLE_TIMEOUT");
            TcpClientConnector tcpConnector = null;
            if (this.getUri().getScheme().startsWith("coaps")) {
                SSLContext sslContext = this.getSslContextParameters().createSSLContext(this.getCamelContext());
                tcpConnector = new TlsClientConnector(sslContext, tcpThreads, tcpConnectTimeout, tcpIdleTimeout);
            } else {
                tcpConnector = new TcpClientConnector(tcpThreads, tcpConnectTimeout, tcpIdleTimeout);
            }
            CoapEndpoint.Builder tcpBuilder = new CoapEndpoint.Builder();
            tcpBuilder.setConnector((Connector)tcpConnector);
            client.setEndpoint((Endpoint)tcpBuilder.build());
        }
        return client;
    }
}

