/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd.springboot;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.cometd.CometdComponent;
import org.apache.camel.component.cometd.springboot.CometdComponentConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@EnableConfigurationProperties(value={CometdComponentConfiguration.class})
@Conditional(value={Condition.class})
public class CometdComponentAutoConfiguration {
    @Lazy
    @Bean(name={"cometd-component", "cometds-component"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={CometdComponent.class})
    public CometdComponent configureCometdComponent(CamelContext camelContext, CometdComponentConfiguration configuration) throws Exception {
        CometdComponent component = new CometdComponent();
        component.setCamelContext(camelContext);
        HashMap parameters = new HashMap();
        IntrospectionSupport.getProperties((Object)configuration, parameters, null, (boolean)false);
        for (Map.Entry entry : parameters.entrySet()) {
            Object value = entry.getValue();
            Class<?> paramClass = value.getClass();
            if (!paramClass.getName().endsWith("NestedConfiguration")) continue;
            Class nestedClass = null;
            try {
                nestedClass = (Class)paramClass.getDeclaredField("CAMEL_NESTED_CLASS").get(null);
                HashMap nestedParameters = new HashMap();
                IntrospectionSupport.getProperties(value, nestedParameters, null, (boolean)false);
                Object nestedProperty = nestedClass.newInstance();
                IntrospectionSupport.setProperties((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), nestedProperty, nestedParameters);
                entry.setValue(nestedProperty);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        IntrospectionSupport.setProperties((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), (Object)component, parameters);
        return component;
    }

    public static class Condition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            boolean groupEnabled = this.isEnabled(conditionContext, "camel.component.", true);
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"camel.component.cometd", (Object[])new Object[0]);
            if (this.isEnabled(conditionContext, "camel.component.cometd.", groupEnabled)) {
                return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
        }

        private boolean isEnabled(ConditionContext context, String prefix, boolean defaultValue) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), prefix);
            return (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)defaultValue);
        }
    }
}

