/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.atomix.AtomixClient;
import io.atomix.catalyst.transport.Address;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.atomix.client.value.AtomixValueComponent;
import org.apache.camel.component.atomix.client.value.AtomixValueConfiguration;

public interface AtomixValueComponentBuilderFactory {
    public static AtomixValueComponentBuilder atomixValue() {
        return new AtomixValueComponentBuilderImpl();
    }

    public static class AtomixValueComponentBuilderImpl
    extends AbstractComponentBuilder<AtomixValueComponent>
    implements AtomixValueComponentBuilder {
        @Override
        protected AtomixValueComponent buildConcreteComponent() {
            return new AtomixValueComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "atomix": {
                    ((AtomixValueComponent)component).setAtomix((AtomixClient)value);
                    return true;
                }
                case "configuration": {
                    ((AtomixValueComponent)component).setConfiguration((AtomixValueConfiguration)value);
                    return true;
                }
                case "configurationUri": {
                    ((AtomixValueComponent)component).setConfigurationUri((String)value);
                    return true;
                }
                case "nodes": {
                    ((AtomixValueComponent)component).setNodes((List)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((AtomixValueComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((AtomixValueComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((AtomixValueComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AtomixValueComponentBuilder
    extends ComponentBuilder<AtomixValueComponent> {
        default public AtomixValueComponentBuilder atomix(AtomixClient atomix) {
            this.doSetProperty("atomix", atomix);
            return this;
        }

        default public AtomixValueComponentBuilder configuration(AtomixValueConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AtomixValueComponentBuilder configurationUri(String configurationUri) {
            this.doSetProperty("configurationUri", configurationUri);
            return this;
        }

        default public AtomixValueComponentBuilder nodes(List<Address> nodes) {
            this.doSetProperty("nodes", nodes);
            return this;
        }

        default public AtomixValueComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AtomixValueComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AtomixValueComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

