/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.cw.Cw2Component;
import org.apache.camel.component.aws2.cw.Cw2Configuration;

public interface Aws2CwComponentBuilderFactory {
    public static Aws2CwComponentBuilder aws2Cw() {
        return new Aws2CwComponentBuilderImpl();
    }

    public static class Aws2CwComponentBuilderImpl
    extends AbstractComponentBuilder<Cw2Component>
    implements Aws2CwComponentBuilder {
        @Override
        protected Cw2Component buildConcreteComponent() {
            return new Cw2Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((Cw2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Cw2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    ((Cw2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((Cw2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((Cw2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((Cw2Component)component).setConfiguration((Cw2Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2CwComponentBuilder
    extends ComponentBuilder<Cw2Component> {
        default public Aws2CwComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2CwComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2CwComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2CwComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2CwComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2CwComponentBuilder configuration(Cw2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

