/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.ddb.Ddb2Component;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;

public interface Aws2DdbComponentBuilderFactory {
    public static Aws2DdbComponentBuilder aws2Ddb() {
        return new Aws2DdbComponentBuilderImpl();
    }

    public static class Aws2DdbComponentBuilderImpl
    extends AbstractComponentBuilder<Ddb2Component>
    implements Aws2DdbComponentBuilder {
        @Override
        protected Ddb2Component buildConcreteComponent() {
            return new Ddb2Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((Ddb2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Ddb2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    ((Ddb2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((Ddb2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((Ddb2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((Ddb2Component)component).setConfiguration((Ddb2Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2DdbComponentBuilder
    extends ComponentBuilder<Ddb2Component> {
        default public Aws2DdbComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2DdbComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2DdbComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2DdbComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2DdbComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2DdbComponentBuilder configuration(Ddb2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

