/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.ec2.AWS2EC2Component;
import org.apache.camel.component.aws2.ec2.AWS2EC2Configuration;

public interface Aws2Ec2ComponentBuilderFactory {
    public static Aws2Ec2ComponentBuilder aws2Ec2() {
        return new Aws2Ec2ComponentBuilderImpl();
    }

    public static class Aws2Ec2ComponentBuilderImpl
    extends AbstractComponentBuilder<AWS2EC2Component>
    implements Aws2Ec2ComponentBuilder {
        @Override
        protected AWS2EC2Component buildConcreteComponent() {
            return new AWS2EC2Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((AWS2EC2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((AWS2EC2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    ((AWS2EC2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((AWS2EC2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((AWS2EC2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((AWS2EC2Component)component).setConfiguration((AWS2EC2Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2Ec2ComponentBuilder
    extends ComponentBuilder<AWS2EC2Component> {
        default public Aws2Ec2ComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2Ec2ComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2Ec2ComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2Ec2ComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2Ec2ComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2Ec2ComponentBuilder configuration(AWS2EC2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

