/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.ecs.ECS2Component;
import org.apache.camel.component.aws2.ecs.ECS2Configuration;

public interface Aws2EcsComponentBuilderFactory {
    public static Aws2EcsComponentBuilder aws2Ecs() {
        return new Aws2EcsComponentBuilderImpl();
    }

    public static class Aws2EcsComponentBuilderImpl
    extends AbstractComponentBuilder<ECS2Component>
    implements Aws2EcsComponentBuilder {
        @Override
        protected ECS2Component buildConcreteComponent() {
            return new ECS2Component();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "accessKey": {
                    ((ECS2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((ECS2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    ((ECS2Component)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    ((ECS2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((ECS2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((ECS2Component)component).setConfiguration((ECS2Configuration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2EcsComponentBuilder
    extends ComponentBuilder<ECS2Component> {
        default public Aws2EcsComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2EcsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2EcsComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2EcsComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2EcsComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2EcsComponentBuilder configuration(ECS2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

